/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.BitMixer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.CharObjectHashMap;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.HashOrderMixing;

public class CharObjectScatterMap<VType>
extends CharObjectHashMap<VType> {
    public CharObjectScatterMap() {
        this(4);
    }

    public CharObjectScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public CharObjectScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(char key) {
        return BitMixer.mixPhi(key);
    }

    public static <VType> CharObjectScatterMap<VType> from(char[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        CharObjectScatterMap<VType> map = new CharObjectScatterMap<VType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

