/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.buffer.ByteBuf;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.handler.codec.TooLongFrameException;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.netty4.Netty4Utils;

final class Netty4SizeHeaderFrameDecoder
extends ByteToMessageDecoder {
    Netty4SizeHeaderFrameDecoder() {
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            boolean continueProcessing = TcpTransport.validateMessageHeader(Netty4Utils.toBytesReference(in));
            ByteBuf message = in.skipBytes(6);
            if (!continueProcessing) {
                return;
            }
            out.add(message);
        }
        catch (IllegalArgumentException ex) {
            throw new TooLongFrameException(ex);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

