/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReader;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.fieldvisitor.SingleFieldsVisitor;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.search.lookup.FieldLookup;

public class LeafFieldsLookup
implements Map {
    private final MapperService mapperService;
    @Nullable
    private final String[] types;
    private final LeafReader reader;
    private int docId = -1;
    private final Map<String, FieldLookup> cachedFieldData = new HashMap<String, FieldLookup>();
    private final SingleFieldsVisitor fieldVisitor;

    LeafFieldsLookup(MapperService mapperService, @Nullable String[] types, LeafReader reader) {
        this.mapperService = mapperService;
        this.types = types;
        this.reader = reader;
        this.fieldVisitor = new SingleFieldsVisitor(null);
    }

    public void setDocument(int docId) {
        if (this.docId == docId) {
            return;
        }
        this.docId = docId;
        this.clearCache();
    }

    public Object get(Object key) {
        return this.loadFieldData(key.toString());
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            this.loadFieldData(key.toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    private FieldLookup loadFieldData(String name) {
        FieldLookup data = this.cachedFieldData.get(name);
        if (data == null) {
            MappedFieldType fieldType = this.mapperService.fullName(name);
            if (fieldType == null) {
                throw new IllegalArgumentException("No field found for [" + name + "] in mapping with types " + Arrays.toString(this.types) + "");
            }
            data = new FieldLookup(fieldType);
            this.cachedFieldData.put(name, data);
        }
        if (data.fields() == null) {
            String fieldName = data.fieldType().name();
            this.fieldVisitor.reset(fieldName);
            try {
                this.reader.document(this.docId, this.fieldVisitor);
                this.fieldVisitor.postProcess(data.fieldType());
                data.fields(Collections.singletonMap(name, this.fieldVisitor.fields().get(data.fieldType().name())));
            }
            catch (IOException e) {
                throw new ElasticsearchParseException("failed to load field [{}]", (Throwable)e, name);
            }
        }
        return data;
    }

    private void clearCache() {
        for (Map.Entry<String, FieldLookup> entry : this.cachedFieldData.entrySet()) {
            entry.getValue().clear();
        }
    }
}

