/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.children;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ConstantScoreScorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Bits;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.children.InternalChildren;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class ParentToChildrenAggregator
extends SingleBucketAggregator {
    static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private final String parentType;
    private final Weight childFilter;
    private final Weight parentFilter;
    private final ValuesSource.Bytes.ParentChild valuesSource;
    private final LongArray parentOrdToBuckets;
    private final LongObjectPagedHashMap<long[]> parentOrdToOtherBuckets;
    private boolean multipleBucketsPerParentOrd = false;

    public ParentToChildrenAggregator(String name, AggregatorFactories factories, SearchContext context, Aggregator parent, String parentType, Query childFilter, Query parentFilter, ValuesSource.Bytes.ParentChild valuesSource, long maxOrd, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, pipelineAggregators, metaData);
        this.parentType = parentType;
        this.childFilter = context.searcher().createNormalizedWeight(childFilter, false);
        this.parentFilter = context.searcher().createNormalizedWeight(parentFilter, false);
        this.parentOrdToBuckets = context.bigArrays().newLongArray(maxOrd, false);
        this.parentOrdToBuckets.fill(0L, maxOrd, -1L);
        this.parentOrdToOtherBuckets = new LongObjectPagedHashMap(context.bigArrays());
        this.valuesSource = valuesSource;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        return new InternalChildren(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalChildren(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedDocValues globalOrdinals = this.valuesSource.globalOrdinalsValues(this.parentType, ctx);
        assert (globalOrdinals != null);
        Scorer parentScorer = this.parentFilter.scorer(ctx);
        final Bits parentDocs = Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), parentScorer);
        return new LeafBucketCollector(){

            @Override
            public void collect(int docId, long bucket) throws IOException {
                long globalOrdinal;
                if (parentDocs.get(docId) && (globalOrdinal = (long)globalOrdinals.getOrd(docId)) != -1L) {
                    if (ParentToChildrenAggregator.this.parentOrdToBuckets.get(globalOrdinal) == -1L) {
                        ParentToChildrenAggregator.this.parentOrdToBuckets.set(globalOrdinal, bucket);
                    } else {
                        long[] bucketOrds = (long[])ParentToChildrenAggregator.this.parentOrdToOtherBuckets.get(globalOrdinal);
                        if (bucketOrds != null) {
                            bucketOrds = Arrays.copyOf(bucketOrds, bucketOrds.length + 1);
                            bucketOrds[bucketOrds.length - 1] = bucket;
                            ParentToChildrenAggregator.this.parentOrdToOtherBuckets.put(globalOrdinal, bucketOrds);
                        } else {
                            ParentToChildrenAggregator.this.parentOrdToOtherBuckets.put(globalOrdinal, new long[]{bucket});
                        }
                        ParentToChildrenAggregator.this.multipleBucketsPerParentOrd = true;
                    }
                }
            }
        };
    }

    @Override
    protected void doPostCollection() throws IOException {
        IndexReader indexReader = this.context().searcher().getIndexReader();
        for (LeafReaderContext ctx : indexReader.leaves()) {
            Scorer childDocsScorer = this.childFilter.scorer(ctx);
            if (childDocsScorer == null) continue;
            DocIdSetIterator childDocsIter = childDocsScorer.iterator();
            LeafBucketCollector sub = this.collectableSubAggregators.getLeafCollector(ctx);
            SortedDocValues globalOrdinals = this.valuesSource.globalOrdinalsValues(this.parentType, ctx);
            sub.setScorer(new ConstantScoreScorer(null, 1.0f, childDocsIter));
            Bits liveDocs = ctx.reader().getLiveDocs();
            int docId = childDocsIter.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                long bucketOrd;
                long globalOrdinal;
                if ((liveDocs == null || liveDocs.get(docId)) && (globalOrdinal = (long)globalOrdinals.getOrd(docId)) != -1L && (bucketOrd = this.parentOrdToBuckets.get(globalOrdinal)) != -1L) {
                    long[] otherBucketOrds;
                    this.collectBucket(sub, docId, bucketOrd);
                    if (this.multipleBucketsPerParentOrd && (otherBucketOrds = this.parentOrdToOtherBuckets.get(globalOrdinal)) != null) {
                        for (long otherBucketOrd : otherBucketOrds) {
                            this.collectBucket(sub, docId, otherBucketOrd);
                        }
                    }
                }
                docId = childDocsIter.nextDoc();
            }
        }
    }

    @Override
    protected void doClose() {
        Releasables.close(this.parentOrdToBuckets, this.parentOrdToOtherBuckets);
    }
}

