/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.AbstractSearchScript;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.NativeScriptFactory;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.SearchLookup;

public class NativeScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    public static final String NAME = "native";
    private final Map<String, NativeScriptFactory> scripts;

    public NativeScriptEngineService(Settings settings, Map<String, NativeScriptFactory> scripts) {
        super(settings);
        this.scripts = Collections.unmodifiableMap(scripts);
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    public String getExtension() {
        return "";
    }

    @Override
    public Object compile(String scriptName, String scriptSource, Map<String, String> params) {
        NativeScriptFactory scriptFactory = this.scripts.get(scriptSource);
        if (scriptFactory != null) {
            return scriptFactory;
        }
        throw new IllegalArgumentException("Native script [" + scriptSource + "] not found");
    }

    @Override
    public ExecutableScript executable(CompiledScript compiledScript, @Nullable Map<String, Object> vars) {
        NativeScriptFactory scriptFactory = (NativeScriptFactory)compiledScript.compiled();
        return scriptFactory.newScript(vars);
    }

    @Override
    public SearchScript search(CompiledScript compiledScript, final SearchLookup lookup, @Nullable Map<String, Object> vars) {
        final NativeScriptFactory scriptFactory = (NativeScriptFactory)compiledScript.compiled();
        final AbstractSearchScript script = (AbstractSearchScript)scriptFactory.newScript(vars);
        return new SearchScript(){

            @Override
            public LeafSearchScript getLeafSearchScript(LeafReaderContext context) throws IOException {
                script.setLookup(lookup.getLeafSearchLookup(context));
                return script;
            }

            @Override
            public boolean needsScores() {
                return scriptFactory.needsScores();
            }
        };
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isInlineScriptEnabled() {
        return true;
    }
}

