/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.PrefixCodedTerms;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.BlendedTermQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.CommonTermsQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.TermsQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BoostQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ConstantScoreQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.PhraseQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SynonymQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TermQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanFirstQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanNotQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.search.MatchNoDocsQuery;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;

public final class QueryAnalyzer {
    private static final Map<Class<? extends Query>, Function<Query, Result>> queryProcessors;

    private QueryAnalyzer() {
    }

    public static Result analyze(Query query) {
        Function<Query, Result> queryProcessor;
        Class<?> queryClass = query.getClass();
        if (queryClass.isAnonymousClass()) {
            queryClass = queryClass.getSuperclass();
        }
        if ((queryProcessor = queryProcessors.get(queryClass)) != null) {
            return queryProcessor.apply(query);
        }
        throw new UnsupportedQueryException(query);
    }

    static Function<Query, Result> matchNoDocsQuery() {
        return query -> new Result(true, Collections.emptySet());
    }

    static Function<Query, Result> constantScoreQuery() {
        return query -> {
            Query wrappedQuery = ((ConstantScoreQuery)query).getQuery();
            return QueryAnalyzer.analyze(wrappedQuery);
        };
    }

    static Function<Query, Result> boostQuery() {
        return query -> {
            Query wrappedQuery = ((BoostQuery)query).getQuery();
            return QueryAnalyzer.analyze(wrappedQuery);
        };
    }

    static Function<Query, Result> termQuery() {
        return query -> {
            TermQuery termQuery = (TermQuery)query;
            return new Result(true, Collections.singleton(termQuery.getTerm()));
        };
    }

    static Function<Query, Result> termsQuery() {
        return query -> {
            TermsQuery termsQuery = (TermsQuery)query;
            HashSet<Term> terms = new HashSet<Term>();
            PrefixCodedTerms.TermIterator iterator = termsQuery.getTermData().iterator();
            BytesRef term = iterator.next();
            while (term != null) {
                terms.add(new Term(iterator.field(), term));
                term = iterator.next();
            }
            return new Result(true, terms);
        };
    }

    static Function<Query, Result> synonymQuery() {
        return query -> {
            HashSet<Term> terms = new HashSet<Term>(((SynonymQuery)query).getTerms());
            return new Result(true, terms);
        };
    }

    static Function<Query, Result> commonTermsQuery() {
        return query -> {
            List<Term> terms = ((CommonTermsQuery)query).getTerms();
            return new Result(false, new HashSet<Term>(terms));
        };
    }

    static Function<Query, Result> blendedTermQuery() {
        return query -> {
            List<Term> terms = ((BlendedTermQuery)query).getTerms();
            return new Result(true, new HashSet<Term>(terms));
        };
    }

    static Function<Query, Result> phraseQuery() {
        return query -> {
            Term[] terms = ((PhraseQuery)query).getTerms();
            if (terms.length == 0) {
                return new Result(true, Collections.emptySet());
            }
            Term longestTerm = terms[0];
            for (Term term : terms) {
                if (longestTerm.bytes().length >= term.bytes().length) continue;
                longestTerm = term;
            }
            return new Result(false, Collections.singleton(longestTerm));
        };
    }

    static Function<Query, Result> spanTermQuery() {
        return query -> {
            Term term = ((SpanTermQuery)query).getTerm();
            return new Result(true, Collections.singleton(term));
        };
    }

    static Function<Query, Result> spanNearQuery() {
        return query -> {
            Set<Term> bestClauses = null;
            SpanNearQuery spanNearQuery = (SpanNearQuery)query;
            for (SpanQuery clause : spanNearQuery.getClauses()) {
                Result temp = QueryAnalyzer.analyze(clause);
                bestClauses = QueryAnalyzer.selectTermListWithTheLongestShortestTerm(temp.terms, bestClauses);
            }
            return new Result(false, bestClauses);
        };
    }

    static Function<Query, Result> spanOrQuery() {
        return query -> {
            HashSet<Term> terms = new HashSet<Term>();
            SpanOrQuery spanOrQuery = (SpanOrQuery)query;
            for (SpanQuery clause : spanOrQuery.getClauses()) {
                terms.addAll(QueryAnalyzer.analyze((Query)clause).terms);
            }
            return new Result(false, terms);
        };
    }

    static Function<Query, Result> spanNotQuery() {
        return query -> {
            Result result = QueryAnalyzer.analyze(((SpanNotQuery)query).getInclude());
            return new Result(false, result.terms);
        };
    }

    static Function<Query, Result> spanFirstQuery() {
        return query -> {
            Result result = QueryAnalyzer.analyze(((SpanFirstQuery)query).getMatch());
            return new Result(false, result.terms);
        };
    }

    static Function<Query, Result> booleanQuery() {
        return query -> {
            BooleanQuery bq = (BooleanQuery)query;
            List<BooleanClause> clauses = bq.clauses();
            int minimumShouldMatch = bq.getMinimumNumberShouldMatch();
            int numRequiredClauses = 0;
            int numOptionalClauses = 0;
            int numProhibitedClauses = 0;
            for (BooleanClause clause : clauses) {
                if (clause.isRequired()) {
                    ++numRequiredClauses;
                }
                if (clause.isProhibited()) {
                    ++numProhibitedClauses;
                }
                if (clause.getOccur() != BooleanClause.Occur.SHOULD) continue;
                ++numOptionalClauses;
            }
            if (numRequiredClauses > 0) {
                Set<Term> bestClause = null;
                UnsupportedQueryException uqe = null;
                for (BooleanClause clause : clauses) {
                    Result temp;
                    if (!clause.isRequired()) continue;
                    try {
                        temp = QueryAnalyzer.analyze(clause.getQuery());
                    }
                    catch (UnsupportedQueryException e) {
                        uqe = e;
                        continue;
                    }
                    bestClause = QueryAnalyzer.selectTermListWithTheLongestShortestTerm(temp.terms, bestClause);
                }
                if (bestClause != null) {
                    return new Result(false, bestClause);
                }
                if (uqe != null) {
                    throw uqe;
                }
                return new Result(true, Collections.emptySet());
            }
            ArrayList<Query> disjunctions = new ArrayList<Query>(numOptionalClauses);
            for (BooleanClause clause : clauses) {
                if (clause.getOccur() != BooleanClause.Occur.SHOULD) continue;
                disjunctions.add(clause.getQuery());
            }
            return QueryAnalyzer.handleDisjunction(disjunctions, minimumShouldMatch, numProhibitedClauses > 0);
        };
    }

    static Function<Query, Result> disjunctionMaxQuery() {
        return query -> {
            List<Query> disjuncts = ((DisjunctionMaxQuery)query).getDisjuncts();
            return QueryAnalyzer.handleDisjunction(disjuncts, 1, false);
        };
    }

    static Function<Query, Result> functionScoreQuery() {
        return query -> {
            FunctionScoreQuery functionScoreQuery = (FunctionScoreQuery)query;
            Result result = QueryAnalyzer.analyze(functionScoreQuery.getSubQuery());
            boolean verified = functionScoreQuery.getMinScore() == null;
            return new Result(verified, result.terms);
        };
    }

    static Result handleDisjunction(List<Query> disjunctions, int minimumShouldMatch, boolean otherClauses) {
        boolean verified = minimumShouldMatch <= 1 && !otherClauses;
        HashSet<Term> terms = new HashSet<Term>();
        for (Query disjunct : disjunctions) {
            Result subResult = QueryAnalyzer.analyze(disjunct);
            if (!subResult.verified) {
                verified = false;
            }
            terms.addAll(subResult.terms);
        }
        return new Result(verified, terms);
    }

    static Set<Term> selectTermListWithTheLongestShortestTerm(Set<Term> terms1, Set<Term> terms2) {
        int terms2ShortestTerm;
        if (terms1 == null) {
            return terms2;
        }
        if (terms2 == null) {
            return terms1;
        }
        int terms1ShortestTerm = QueryAnalyzer.minTermLength(terms1);
        if (terms1ShortestTerm >= (terms2ShortestTerm = QueryAnalyzer.minTermLength(terms2))) {
            return terms1;
        }
        return terms2;
    }

    static int minTermLength(Set<Term> terms) {
        int min = Integer.MAX_VALUE;
        for (Term term : terms) {
            min = Math.min(min, term.bytes().length);
        }
        return min;
    }

    static {
        HashMap<Class<FunctionScoreQuery>, Function<Query, Result>> map = new HashMap<Class<FunctionScoreQuery>, Function<Query, Result>>();
        map.put(MatchNoDocsQuery.class, QueryAnalyzer.matchNoDocsQuery());
        map.put(ConstantScoreQuery.class, QueryAnalyzer.constantScoreQuery());
        map.put(BoostQuery.class, QueryAnalyzer.boostQuery());
        map.put(TermQuery.class, QueryAnalyzer.termQuery());
        map.put(TermsQuery.class, QueryAnalyzer.termsQuery());
        map.put(CommonTermsQuery.class, QueryAnalyzer.commonTermsQuery());
        map.put(BlendedTermQuery.class, QueryAnalyzer.blendedTermQuery());
        map.put(PhraseQuery.class, QueryAnalyzer.phraseQuery());
        map.put(SpanTermQuery.class, QueryAnalyzer.spanTermQuery());
        map.put(SpanNearQuery.class, QueryAnalyzer.spanNearQuery());
        map.put(SpanOrQuery.class, QueryAnalyzer.spanOrQuery());
        map.put(SpanFirstQuery.class, QueryAnalyzer.spanFirstQuery());
        map.put(SpanNotQuery.class, QueryAnalyzer.spanNotQuery());
        map.put(BooleanQuery.class, QueryAnalyzer.booleanQuery());
        map.put(DisjunctionMaxQuery.class, QueryAnalyzer.disjunctionMaxQuery());
        map.put(SynonymQuery.class, QueryAnalyzer.synonymQuery());
        map.put(FunctionScoreQuery.class, QueryAnalyzer.functionScoreQuery());
        queryProcessors = Collections.unmodifiableMap(map);
    }

    static class UnsupportedQueryException
    extends RuntimeException {
        private final Query unsupportedQuery;

        UnsupportedQueryException(Query unsupportedQuery) {
            super(LoggerMessageFormat.format("no query terms can be extracted from query [{}]", unsupportedQuery));
            this.unsupportedQuery = unsupportedQuery;
        }

        public Query getUnsupportedQuery() {
            return this.unsupportedQuery;
        }
    }

    static class Result {
        final Set<Term> terms;
        final boolean verified;

        Result(boolean verified, Set<Term> terms) {
            this.terms = terms;
            this.verified = verified;
        }
    }
}

