/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.RandomAccessWeight;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Bits;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;

@Deprecated
public class LegacyInMemoryGeoBoundingBoxQuery
extends Query {
    private final GeoPoint topLeft;
    private final GeoPoint bottomRight;
    private final IndexGeoPointFieldData indexFieldData;

    public LegacyInMemoryGeoBoundingBoxQuery(GeoPoint topLeft, GeoPoint bottomRight, IndexGeoPointFieldData indexFieldData) {
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
        this.indexFieldData = indexFieldData;
    }

    public GeoPoint topLeft() {
        return this.topLeft;
    }

    public GeoPoint bottomRight() {
        return this.bottomRight;
    }

    public String fieldName() {
        return this.indexFieldData.getFieldName();
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new RandomAccessWeight(this){

            @Override
            protected Bits getMatchingDocs(LeafReaderContext context) throws IOException {
                int maxDoc = context.reader().maxDoc();
                MultiGeoPointValues values = ((AtomicGeoPointFieldData)LegacyInMemoryGeoBoundingBoxQuery.this.indexFieldData.load(context)).getGeoPointValues();
                if (LegacyInMemoryGeoBoundingBoxQuery.this.topLeft.lon() > LegacyInMemoryGeoBoundingBoxQuery.this.bottomRight.lon()) {
                    return new Meridian180GeoBoundingBoxBits(maxDoc, values, LegacyInMemoryGeoBoundingBoxQuery.this.topLeft, LegacyInMemoryGeoBoundingBoxQuery.this.bottomRight);
                }
                return new GeoBoundingBoxBits(maxDoc, values, LegacyInMemoryGeoBoundingBoxQuery.this.topLeft, LegacyInMemoryGeoBoundingBoxQuery.this.bottomRight);
            }
        };
    }

    @Override
    public String toString(String field) {
        return "GeoBoundingBoxFilter(" + this.indexFieldData.getFieldName() + ", " + this.topLeft + ", " + this.bottomRight + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        LegacyInMemoryGeoBoundingBoxQuery other = (LegacyInMemoryGeoBoundingBoxQuery)obj;
        return this.fieldName().equalsIgnoreCase(other.fieldName()) && this.topLeft.equals(other.topLeft) && this.bottomRight.equals(other.bottomRight);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.classHash(), this.fieldName(), this.topLeft, this.bottomRight);
    }

    private static class GeoBoundingBoxBits
    implements Bits {
        private final int maxDoc;
        private final MultiGeoPointValues values;
        private final GeoPoint topLeft;
        private final GeoPoint bottomRight;

        GeoBoundingBoxBits(int maxDoc, MultiGeoPointValues values, GeoPoint topLeft, GeoPoint bottomRight) {
            this.maxDoc = maxDoc;
            this.values = values;
            this.topLeft = topLeft;
            this.bottomRight = bottomRight;
        }

        @Override
        public boolean get(int doc) {
            this.values.setDocument(doc);
            int length = this.values.count();
            for (int i = 0; i < length; ++i) {
                GeoPoint point = this.values.valueAt(i);
                if (!(this.topLeft.lon() <= point.lon()) || !(this.bottomRight.lon() >= point.lon()) || !(this.topLeft.lat() >= point.lat()) || !(this.bottomRight.lat() <= point.lat())) continue;
                return true;
            }
            return false;
        }

        @Override
        public int length() {
            return this.maxDoc;
        }
    }

    private static class Meridian180GeoBoundingBoxBits
    implements Bits {
        private final int maxDoc;
        private final MultiGeoPointValues values;
        private final GeoPoint topLeft;
        private final GeoPoint bottomRight;

        Meridian180GeoBoundingBoxBits(int maxDoc, MultiGeoPointValues values, GeoPoint topLeft, GeoPoint bottomRight) {
            this.maxDoc = maxDoc;
            this.values = values;
            this.topLeft = topLeft;
            this.bottomRight = bottomRight;
        }

        @Override
        public boolean get(int doc) {
            this.values.setDocument(doc);
            int length = this.values.count();
            for (int i = 0; i < length; ++i) {
                GeoPoint point = this.values.valueAt(i);
                if (!(this.topLeft.lon() <= point.lon()) && !(this.bottomRight.lon() >= point.lon()) || !(this.topLeft.lat() >= point.lat()) || !(this.bottomRight.lat() <= point.lat())) continue;
                return true;
            }
            return false;
        }

        @Override
        public int length() {
            return this.maxDoc;
        }
    }
}

