/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.bulk.byscroll.AbstractBulkByScrollRequest;
import org.elasticsearch.action.bulk.byscroll.BulkByScrollResponse;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponseContentListener;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.LoggingTaskListener;
import org.elasticsearch.tasks.Task;

public abstract class AbstractBaseReindexRestHandler<Request extends AbstractBulkByScrollRequest<Request>, A extends GenericAction<Request, BulkByScrollResponse>>
extends BaseRestHandler {
    private final A action;

    protected AbstractBaseReindexRestHandler(Settings settings, A action) {
        super(settings);
        this.action = action;
    }

    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, NodeClient client, boolean includeCreated, boolean includeUpdated) throws IOException {
        Request internal = this.setCommonOptions(request, this.buildRequest(request));
        if (request.paramAsBoolean("wait_for_completion", true)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("include_created", Boolean.toString(includeCreated));
            params.put("include_updated", Boolean.toString(includeUpdated));
            return channel -> client.executeLocally(this.action, internal, new BulkIndexByScrollResponseContentListener((RestChannel)channel, (Map<String, String>)params));
        }
        ((AbstractBulkByScrollRequest)internal).setShouldStoreResult(true);
        ActionRequestValidationException validationException = ((AbstractBulkByScrollRequest)internal).validate();
        if (validationException != null) {
            throw validationException;
        }
        return this.sendTask(client.getLocalNodeId(), client.executeLocally(this.action, internal, LoggingTaskListener.instance()));
    }

    protected abstract Request buildRequest(RestRequest var1) throws IOException;

    protected Request setCommonOptions(RestRequest restRequest, Request request) {
        Float requestsPerSecond;
        assert (restRequest != null) : "RestRequest should not be null";
        assert (request != null) : "Request should not be null";
        ((AbstractBulkByScrollRequest)request).setRefresh(restRequest.paramAsBoolean("refresh", ((AbstractBulkByScrollRequest)request).isRefresh()));
        ((AbstractBulkByScrollRequest)request).setTimeout(restRequest.paramAsTime("timeout", ((AbstractBulkByScrollRequest)request).getTimeout()));
        ((AbstractBulkByScrollRequest)request).setSlices(restRequest.paramAsInt("slices", ((AbstractBulkByScrollRequest)request).getSlices()));
        String waitForActiveShards = restRequest.param("wait_for_active_shards");
        if (waitForActiveShards != null) {
            ((AbstractBulkByScrollRequest)request).setWaitForActiveShards(ActiveShardCount.parseString(waitForActiveShards));
        }
        if ((requestsPerSecond = AbstractBaseReindexRestHandler.parseRequestsPerSecond(restRequest)) != null) {
            ((AbstractBulkByScrollRequest)request).setRequestsPerSecond(requestsPerSecond.floatValue());
        }
        return request;
    }

    private BaseRestHandler.RestChannelConsumer sendTask(String localNodeId, Task task) throws IOException {
        return channel -> {
            try (XContentBuilder builder = channel.newBuilder();){
                builder.startObject();
                builder.field("task", localNodeId + ":" + task.getId());
                builder.endObject();
                channel.sendResponse(new BytesRestResponse(RestStatus.OK, builder));
            }
        };
    }

    public static Float parseRequestsPerSecond(RestRequest request) {
        float requestsPerSecond;
        String requestsPerSecondString = request.param("requests_per_second");
        if (requestsPerSecondString == null) {
            return null;
        }
        try {
            requestsPerSecond = Float.parseFloat(requestsPerSecondString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("[requests_per_second] must be a float greater than 0. Use -1 to disable throttling.", e);
        }
        if (requestsPerSecond == -1.0f) {
            return Float.valueOf(Float.POSITIVE_INFINITY);
        }
        if (requestsPerSecond <= 0.0f) {
            throw new IllegalArgumentException("[requests_per_second] must be a float greater than 0. Use -1 to disable throttling.");
        }
        return Float.valueOf(requestsPerSecond);
    }
}

