/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanQuery;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.SpanQueryBuilder;

public class SpanNearQueryBuilder
extends AbstractQueryBuilder<SpanNearQueryBuilder>
implements SpanQueryBuilder {
    public static final String NAME = "span_near";
    public static boolean DEFAULT_IN_ORDER = true;
    private static final ParseField SLOP_FIELD = new ParseField("slop", new String[0]);
    private static final ParseField COLLECT_PAYLOADS_FIELD = new ParseField("collect_payloads", new String[0]).withAllDeprecated("no longer supported");
    private static final ParseField CLAUSES_FIELD = new ParseField("clauses", new String[0]);
    private static final ParseField IN_ORDER_FIELD = new ParseField("in_order", new String[0]);
    private final List<SpanQueryBuilder> clauses = new ArrayList<SpanQueryBuilder>();
    private final int slop;
    private boolean inOrder = DEFAULT_IN_ORDER;

    public SpanNearQueryBuilder(SpanQueryBuilder initialClause, int slop) {
        if (initialClause == null) {
            throw new IllegalArgumentException("[span_near] must include at least one clause");
        }
        this.clauses.add(initialClause);
        this.slop = slop;
    }

    public SpanNearQueryBuilder(StreamInput in) throws IOException {
        super(in);
        for (QueryBuilder clause : SpanNearQueryBuilder.readQueries(in)) {
            this.clauses.add((SpanQueryBuilder)clause);
        }
        this.slop = in.readVInt();
        this.inOrder = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        SpanNearQueryBuilder.writeQueries(out, this.clauses);
        out.writeVInt(this.slop);
        out.writeBoolean(this.inOrder);
    }

    public int slop() {
        return this.slop;
    }

    public SpanNearQueryBuilder addClause(SpanQueryBuilder clause) {
        if (clause == null) {
            throw new IllegalArgumentException("[span_near]  clauses cannot be null");
        }
        this.clauses.add(clause);
        return this;
    }

    public List<SpanQueryBuilder> clauses() {
        return Collections.unmodifiableList(this.clauses);
    }

    public SpanNearQueryBuilder inOrder(boolean inOrder) {
        this.inOrder = inOrder;
        return this;
    }

    public boolean inOrder() {
        return this.inOrder;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startArray(CLAUSES_FIELD.getPreferredName());
        for (SpanQueryBuilder clause : this.clauses) {
            clause.toXContent(builder, params);
        }
        builder.endArray();
        builder.field(SLOP_FIELD.getPreferredName(), this.slop);
        builder.field(IN_ORDER_FIELD.getPreferredName(), this.inOrder);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static Optional<SpanNearQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        float boost = 1.0f;
        Integer slop = null;
        boolean inOrder = DEFAULT_IN_ORDER;
        String queryName = null;
        ArrayList<SpanQueryBuilder> clauses = new ArrayList<SpanQueryBuilder>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (CLAUSES_FIELD.match(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        Optional<QueryBuilder> query = parseContext.parseInnerQueryBuilder();
                        if (!query.isPresent() || !(query.get() instanceof SpanQueryBuilder)) {
                            throw new ParsingException(parser.getTokenLocation(), "spanNear [clauses] must be of type span query", new Object[0]);
                        }
                        clauses.add((SpanQueryBuilder)query.get());
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[span_near] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token.isValue()) {
                if (IN_ORDER_FIELD.match(currentFieldName)) {
                    inOrder = parser.booleanValue();
                    continue;
                }
                if (COLLECT_PAYLOADS_FIELD.match(currentFieldName)) continue;
                if (SLOP_FIELD.match(currentFieldName)) {
                    slop = parser.intValue();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                    queryName = parser.text();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[span_near] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[span_near] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (clauses.isEmpty()) {
            throw new ParsingException(parser.getTokenLocation(), "span_near must include [clauses]", new Object[0]);
        }
        if (slop == null) {
            throw new ParsingException(parser.getTokenLocation(), "span_near must include [slop]", new Object[0]);
        }
        SpanNearQueryBuilder queryBuilder = new SpanNearQueryBuilder((SpanQueryBuilder)clauses.get(0), slop);
        for (int i = 1; i < clauses.size(); ++i) {
            queryBuilder.addClause((SpanQueryBuilder)clauses.get(i));
        }
        queryBuilder.inOrder(inOrder);
        queryBuilder.boost(boost);
        queryBuilder.queryName(queryName);
        return Optional.of(queryBuilder);
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        SpanQuery[] spanQueries = new SpanQuery[this.clauses.size()];
        for (int i = 0; i < this.clauses.size(); ++i) {
            Query query = this.clauses.get(i).toQuery(context);
            assert (query instanceof SpanQuery);
            spanQueries[i] = (SpanQuery)query;
        }
        return new SpanNearQuery(spanQueries, this.slop, this.inOrder);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.clauses, this.slop, this.inOrder);
    }

    @Override
    protected boolean doEquals(SpanNearQueryBuilder other) {
        return Objects.equals(this.clauses, other.clauses) && Objects.equals(this.slop, other.slop) && Objects.equals(this.inOrder, other.inOrder);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

