/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.MultiFields;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.LegacyNumericUtils;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.NumericUtils;
import org.elasticsearch.Version;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.LegacyNumberFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;

public class LegacyFloatFieldMapper
extends LegacyNumberFieldMapper {
    public static final String CONTENT_TYPE = "float";

    protected LegacyFloatFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Boolean includeInAll, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, ignoreMalformed, coerce, includeInAll, indexSettings, multiFields, copyTo);
    }

    @Override
    public FloatFieldType fieldType() {
        return (FloatFieldType)super.fieldType();
    }

    private static float parseValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).floatValue();
        }
        if (value instanceof BytesRef) {
            return Float.parseFloat(((BytesRef)value).utf8ToString());
        }
        return Float.parseFloat(value.toString());
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected void innerParseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        float value;
        float boost = this.fieldType().boost();
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue == null) {
                if (this.fieldType().nullValue() == null) {
                    return;
                }
                value = this.fieldType().nullValue().floatValue();
            } else if (externalValue instanceof String) {
                String sExternalValue = (String)externalValue;
                if (sExternalValue.length() == 0) {
                    if (this.fieldType().nullValue() == null) {
                        return;
                    }
                    value = this.fieldType().nullValue().floatValue();
                } else {
                    value = Float.parseFloat(sExternalValue);
                }
            } else {
                value = ((Number)externalValue).floatValue();
            }
            if (context.includeInAll(this.includeInAll, this)) {
                context.allEntries().addText(this.fieldType().name(), Float.toString(value), boost);
            }
        } else {
            XContentParser parser = context.parser();
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL || parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
                if (this.fieldType().nullValue() == null) {
                    return;
                }
                value = this.fieldType().nullValue().floatValue();
                if (this.fieldType().nullValueAsString() != null && context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.fieldType().name(), this.fieldType().nullValueAsString(), boost);
                }
            } else if (parser.currentToken() == XContentParser.Token.START_OBJECT && Version.indexCreated(context.indexSettings()).before(Version.V_5_0_0_alpha1)) {
                XContentParser.Token token;
                String currentFieldName = null;
                Float objValue = this.fieldType().nullValue();
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        objValue = Float.valueOf(parser.floatValue((Boolean)this.coerce.value()));
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new IllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
                if (objValue == null) {
                    return;
                }
                value = objValue.floatValue();
            } else {
                value = parser.floatValue((Boolean)this.coerce.value());
                if (context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.fieldType().name(), parser.text(), boost);
                }
            }
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            CustomFloatNumericField field = new CustomFloatNumericField(value, this.fieldType());
            if (boost != 1.0f && Version.indexCreated(context.indexSettings()).before(Version.V_5_0_0_alpha1)) {
                field.setBoost(boost);
            }
            fields.add(field);
        }
        if (this.fieldType().hasDocValues()) {
            this.addDocValue(context, fields, NumericUtils.floatToSortableInt(value));
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().numericPrecisionStep() != 8) {
            builder.field("precision_step", this.fieldType().numericPrecisionStep());
        }
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValue());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
    }

    public static class CustomFloatNumericField
    extends LegacyNumberFieldMapper.CustomNumericField {
        private final float number;

        public CustomFloatNumericField(float number, LegacyNumberFieldMapper.NumberFieldType fieldType) {
            super(Float.valueOf(number), fieldType);
            this.number = number;
        }

        @Override
        public TokenStream tokenStream(Analyzer analyzer, TokenStream previous) {
            if (this.fieldType().indexOptions() != IndexOptions.NONE) {
                return this.getCachedStream().setFloatValue(this.number);
            }
            return null;
        }

        @Override
        public String numericAsString() {
            return Float.toString(this.number);
        }
    }

    static final class FloatFieldType
    extends LegacyNumberFieldMapper.NumberFieldType {
        FloatFieldType() {
            super(FieldType.LegacyNumericType.FLOAT);
        }

        protected FloatFieldType(FloatFieldType ref) {
            super(ref);
        }

        @Override
        public LegacyNumberFieldMapper.NumberFieldType clone() {
            return new FloatFieldType(this);
        }

        @Override
        public String typeName() {
            return LegacyFloatFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Float nullValue() {
            return (Float)super.nullValue();
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            int intValue = NumericUtils.floatToSortableInt(LegacyFloatFieldMapper.parseValue(value));
            BytesRefBuilder bytesRef = new BytesRefBuilder();
            LegacyNumericUtils.intToPrefixCoded(intValue, 0, bytesRef);
            return bytesRef.get();
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            return LegacyNumericRangeQuery.newFloatRange(this.name(), this.numericPrecisionStep(), lowerTerm == null ? null : Float.valueOf(LegacyFloatFieldMapper.parseValue(lowerTerm)), upperTerm == null ? null : Float.valueOf(LegacyFloatFieldMapper.parseValue(upperTerm)), includeLower, includeUpper);
        }

        @Override
        public FieldStats.Double stats(IndexReader reader) throws IOException {
            int maxDoc = reader.maxDoc();
            FieldInfo fi = MultiFields.getMergedFieldInfos(reader).fieldInfo(this.name());
            if (fi == null) {
                return null;
            }
            Terms terms = MultiFields.getTerms(reader, this.name());
            if (terms == null) {
                return new FieldStats.Double(maxDoc, 0L, -1L, -1L, this.isSearchable(), this.isAggregatable());
            }
            float minValue = NumericUtils.sortableIntToFloat(LegacyNumericUtils.getMinInt(terms));
            float maxValue = NumericUtils.sortableIntToFloat(LegacyNumericUtils.getMaxInt(terms));
            return new FieldStats.Double(maxDoc, terms.getDocCount(), terms.getSumDocFreq(), terms.getSumTotalTermFreq(), this.isSearchable(), this.isAggregatable(), minValue, maxValue);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.FLOAT);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                if (propNode == null) {
                    throw new MapperParsingException("Property [null_value] cannot be null.");
                }
                builder.nullValue(Float.valueOf(XContentMapValues.nodeFloatValue(propNode)));
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends LegacyNumberFieldMapper.Builder<Builder, LegacyFloatFieldMapper> {
        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, 8);
            this.builder = this;
        }

        @Override
        public LegacyFloatFieldMapper build(Mapper.BuilderContext context) {
            if (context.indexCreatedVersion().onOrAfter(Version.V_5_0_0_alpha2)) {
                throw new IllegalStateException("Cannot use legacy numeric types after 5.0");
            }
            this.setupFieldType(context);
            return new LegacyFloatFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), this.includeInAll, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }

        @Override
        protected int maxPrecisionStep() {
            return 32;
        }
    }

    public static class Defaults
    extends LegacyNumberFieldMapper.Defaults {
        public static final MappedFieldType FIELD_TYPE = new FloatFieldType();

        static {
            FIELD_TYPE.freeze();
        }
    }
}

