/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.joda.time.DateTime;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.joda.time.DateTimeZone;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.joda.time.MutableDateTime;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.joda.time.ReadableDateTime;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

public abstract class ScriptDocValues<T>
extends AbstractList<T> {
    public abstract void setNextDocId(int var1);

    public final List<T> getValues() {
        return this;
    }

    @Override
    public final void add(int index, T element) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final boolean remove(Object o) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final void replaceAll(UnaryOperator<T> operator) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final T set(int index, T element) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final void sort(Comparator<? super T> c) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    public static final class BytesRefs
    extends ScriptDocValues<BytesRef> {
        private final SortedBinaryDocValues values;

        public BytesRefs(SortedBinaryDocValues values) {
            this.values = values;
        }

        @Override
        public void setNextDocId(int docId) {
            this.values.setDocument(docId);
        }

        public SortedBinaryDocValues getInternalValues() {
            return this.values;
        }

        public BytesRef getValue() {
            int numValues = this.values.count();
            if (numValues == 0) {
                return new BytesRef();
            }
            return this.values.valueAt(0);
        }

        @Override
        public BytesRef get(int index) {
            return this.values.valueAt(index);
        }

        @Override
        public int size() {
            return this.values.count();
        }
    }

    public static final class Booleans
    extends ScriptDocValues<Boolean> {
        private final SortedNumericDocValues values;

        public Booleans(SortedNumericDocValues values) {
            this.values = values;
        }

        @Override
        public void setNextDocId(int docId) {
            this.values.setDocument(docId);
        }

        public boolean getValue() {
            return this.values.count() != 0 && this.values.valueAt(0) == 1L;
        }

        @Override
        public Boolean get(int index) {
            return this.values.valueAt(index) == 1L;
        }

        @Override
        public int size() {
            return this.values.count();
        }
    }

    public static final class GeoPoints
    extends ScriptDocValues<GeoPoint> {
        private final MultiGeoPointValues values;

        public GeoPoints(MultiGeoPointValues values) {
            this.values = values;
        }

        @Override
        public void setNextDocId(int docId) {
            this.values.setDocument(docId);
        }

        public GeoPoint getValue() {
            int numValues = this.values.count();
            if (numValues == 0) {
                return null;
            }
            return this.values.valueAt(0);
        }

        public double getLat() {
            return this.getValue().lat();
        }

        public double[] getLats() {
            List points = this.getValues();
            double[] lats = new double[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                lats[i] = ((GeoPoint)points.get(i)).lat();
            }
            return lats;
        }

        public double[] getLons() {
            List points = this.getValues();
            double[] lons = new double[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                lons[i] = ((GeoPoint)points.get(i)).lon();
            }
            return lons;
        }

        public double getLon() {
            return this.getValue().lon();
        }

        @Override
        public GeoPoint get(int index) {
            GeoPoint point = this.values.valueAt(index);
            return new GeoPoint(point.lat(), point.lon());
        }

        @Override
        public int size() {
            return this.values.count();
        }

        public double arcDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoUtils.arcDistance(point.lat(), point.lon(), lat, lon);
        }

        public double arcDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.arcDistance(lat, lon);
        }

        public double planeDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoUtils.planeDistance(point.lat(), point.lon(), lat, lon);
        }

        public double planeDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.planeDistance(lat, lon);
        }

        public double geohashDistance(String geohash) {
            GeoPoint point = this.getValue();
            return GeoUtils.arcDistance(point.lat(), point.lon(), GeoHashUtils.decodeLatitude(geohash), GeoHashUtils.decodeLongitude(geohash));
        }

        public double geohashDistanceWithDefault(String geohash, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.geohashDistance(geohash);
        }
    }

    public static final class Doubles
    extends ScriptDocValues<Double> {
        private final SortedNumericDoubleValues values;

        public Doubles(SortedNumericDoubleValues values) {
            this.values = values;
        }

        @Override
        public void setNextDocId(int docId) {
            this.values.setDocument(docId);
        }

        public SortedNumericDoubleValues getInternalValues() {
            return this.values;
        }

        public double getValue() {
            int numValues = this.values.count();
            if (numValues == 0) {
                return 0.0;
            }
            return this.values.valueAt(0);
        }

        @Override
        public Double get(int index) {
            return this.values.valueAt(index);
        }

        @Override
        public int size() {
            return this.values.count();
        }
    }

    public static final class Dates
    extends ScriptDocValues<ReadableDateTime> {
        private static final ReadableDateTime EPOCH = new DateTime(0L, DateTimeZone.UTC);
        private final SortedNumericDocValues values;
        private MutableDateTime[] dates;

        public Dates(SortedNumericDocValues values) {
            this.values = values;
        }

        public ReadableDateTime getValue() {
            if (this.values.count() == 0) {
                return EPOCH;
            }
            return this.get(0);
        }

        @Override
        public ReadableDateTime get(int index) {
            if (index >= this.values.count()) {
                throw new IndexOutOfBoundsException("attempted to fetch the [" + index + "] date when there are only [" + this.values.count() + "] dates.");
            }
            return this.dates[index];
        }

        @Override
        public int size() {
            return this.values.count();
        }

        @Override
        public void setNextDocId(int docId) {
            this.values.setDocument(docId);
            this.refreshArray();
        }

        void refreshArray() {
            if (this.values.count() == 0) {
                return;
            }
            if (this.dates == null) {
                this.dates = new MutableDateTime[this.values.count()];
                for (int i = 0; i < this.dates.length; ++i) {
                    this.dates[i] = new MutableDateTime(this.values.valueAt(i), DateTimeZone.UTC);
                }
                return;
            }
            if (this.values.count() > this.dates.length) {
                int i;
                MutableDateTime[] backup = this.dates;
                this.dates = new MutableDateTime[this.values.count()];
                System.arraycopy(backup, 0, this.dates, 0, backup.length);
                for (i = 0; i < backup.length; ++i) {
                    this.dates[i].setMillis(this.values.valueAt(i));
                }
                for (i = backup.length; i < this.dates.length; ++i) {
                    this.dates[i] = new MutableDateTime(this.values.valueAt(i), DateTimeZone.UTC);
                }
                return;
            }
            for (int i = 0; i < this.values.count(); ++i) {
                this.dates[i].setMillis(this.values.valueAt(i));
            }
        }
    }

    public static final class Longs
    extends ScriptDocValues<Long> {
        private final SortedNumericDocValues values;
        private Dates dates;

        public Longs(SortedNumericDocValues values) {
            this.values = values;
        }

        @Override
        public void setNextDocId(int docId) {
            this.values.setDocument(docId);
            if (this.dates != null) {
                this.dates.refreshArray();
            }
        }

        public SortedNumericDocValues getInternalValues() {
            return this.values;
        }

        public long getValue() {
            int numValues = this.values.count();
            if (numValues == 0) {
                return 0L;
            }
            return this.values.valueAt(0);
        }

        public ReadableDateTime getDate() {
            if (this.dates == null) {
                this.dates = new Dates(this.values);
                this.dates.refreshArray();
            }
            return this.dates.getValue();
        }

        public List<ReadableDateTime> getDates() {
            if (this.dates == null) {
                this.dates = new Dates(this.values);
                this.dates.refreshArray();
            }
            return this.dates;
        }

        @Override
        public Long get(int index) {
            return this.values.valueAt(index);
        }

        @Override
        public int size() {
            return this.values.count();
        }
    }

    public static final class Strings
    extends ScriptDocValues<String> {
        private final SortedBinaryDocValues values;

        public Strings(SortedBinaryDocValues values) {
            this.values = values;
        }

        @Override
        public void setNextDocId(int docId) {
            this.values.setDocument(docId);
        }

        public SortedBinaryDocValues getInternalValues() {
            return this.values;
        }

        public BytesRef getBytesValue() {
            if (this.values.count() > 0) {
                return this.values.valueAt(0);
            }
            return null;
        }

        public String getValue() {
            BytesRef value = this.getBytesValue();
            if (value == null) {
                return null;
            }
            return value.utf8ToString();
        }

        @Override
        public String get(int index) {
            return this.values.valueAt(index).utf8ToString();
        }

        @Override
        public int size() {
            return this.values.count();
        }
    }
}

