/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.cjk.CJKBigramFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.miscellaneous.DisableGraphAttribute;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public final class CJKBigramFilterFactory
extends AbstractTokenFilterFactory {
    private final int flags;
    private final boolean outputUnigrams;

    public CJKBigramFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.outputUnigrams = settings.getAsBoolean("output_unigrams", false);
        String[] asArray = settings.getAsArray("ignored_scripts");
        HashSet<String> scripts = new HashSet<String>(Arrays.asList("han", "hiragana", "katakana", "hangul"));
        if (asArray != null) {
            scripts.removeAll(Arrays.asList(asArray));
        }
        int flags = 0;
        for (String script : scripts) {
            if ("han".equals(script)) {
                flags |= 1;
                continue;
            }
            if ("hiragana".equals(script)) {
                flags |= 2;
                continue;
            }
            if ("katakana".equals(script)) {
                flags |= 4;
                continue;
            }
            if (!"hangul".equals(script)) continue;
            flags |= 8;
        }
        this.flags = flags;
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        CJKBigramFilter filter = new CJKBigramFilter(tokenStream, this.flags, this.outputUnigrams);
        if (this.outputUnigrams) {
            filter.addAttribute(DisableGraphAttribute.class);
        }
        return filter;
    }
}

