/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4.pipelining;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.channel.ChannelPromise;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.handler.codec.http.FullHttpResponse;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.handler.codec.http.LastHttpContent;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.util.ReferenceCounted;
import org.elasticsearch.http.netty4.pipelining.HttpPipelinedResponse;

public class HttpPipelinedRequest
implements ReferenceCounted {
    private final LastHttpContent last;
    private final int sequence;

    public HttpPipelinedRequest(LastHttpContent last, int sequence) {
        this.last = last;
        this.sequence = sequence;
    }

    public LastHttpContent last() {
        return this.last;
    }

    public HttpPipelinedResponse createHttpResponse(FullHttpResponse response, ChannelPromise promise) {
        return new HttpPipelinedResponse(response, promise, this.sequence);
    }

    @Override
    public int refCnt() {
        return this.last.refCnt();
    }

    @Override
    public ReferenceCounted retain() {
        this.last.retain();
        return this;
    }

    @Override
    public ReferenceCounted retain(int increment) {
        this.last.retain(increment);
        return this;
    }

    @Override
    public ReferenceCounted touch() {
        this.last.touch();
        return this;
    }

    @Override
    public ReferenceCounted touch(Object hint) {
        this.last.touch(hint);
        return this;
    }

    @Override
    public boolean release() {
        return this.last.release();
    }

    @Override
    public boolean release(int decrement) {
        return this.last.release(decrement);
    }
}

