/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.security.auth.DestroyFailedException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.DataInput;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.SimpleFSDirectory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.SetOnce;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;

public class KeyStoreWrapper
implements SecureSettings {
    private static final String KEYSTORE_FILENAME = "elasticsearch.keystore";
    private static final int FORMAT_VERSION = 1;
    private static final String NEW_KEYSTORE_TYPE = "PKCS12";
    private static final String NEW_KEYSTORE_SECRET_KEY_ALGO = "PBE";
    private static final CharsetEncoder ASCII_ENCODER = StandardCharsets.US_ASCII.newEncoder();
    private final boolean hasPassword;
    private final String type;
    private final SecretKeyFactory secretFactory;
    private final byte[] keystoreBytes;
    private final SetOnce<KeyStore> keystore = new SetOnce();
    private final SetOnce<KeyStore.PasswordProtection> keystorePassword = new SetOnce();
    private final Set<String> settingNames = new HashSet<String>();

    private KeyStoreWrapper(boolean hasPassword, String type, String secretKeyAlgo, byte[] keystoreBytes) {
        this.hasPassword = hasPassword;
        this.type = type;
        try {
            this.secretFactory = SecretKeyFactory.getInstance(secretKeyAlgo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.keystoreBytes = keystoreBytes;
    }

    static Path keystorePath(Path configDir) {
        return configDir.resolve(KEYSTORE_FILENAME);
    }

    static KeyStoreWrapper create(char[] password) throws Exception {
        KeyStoreWrapper wrapper = new KeyStoreWrapper(password.length != 0, NEW_KEYSTORE_TYPE, NEW_KEYSTORE_SECRET_KEY_ALGO, null);
        KeyStore keyStore = KeyStore.getInstance(NEW_KEYSTORE_TYPE);
        keyStore.load(null, null);
        wrapper.keystore.set(keyStore);
        wrapper.keystorePassword.set(new KeyStore.PasswordProtection(password));
        return wrapper;
    }

    public static KeyStoreWrapper load(Path configDir) throws IOException {
        Path keystoreFile = KeyStoreWrapper.keystorePath(configDir);
        if (!Files.exists(keystoreFile, new LinkOption[0])) {
            return null;
        }
        SimpleFSDirectory directory = new SimpleFSDirectory(configDir);
        try (IndexInput indexInput = directory.openInput(KEYSTORE_FILENAME, IOContext.READONCE);){
            boolean hasPassword;
            BufferedChecksumIndexInput input = new BufferedChecksumIndexInput(indexInput);
            CodecUtil.checkHeader(input, KEYSTORE_FILENAME, 1, 1);
            byte hasPasswordByte = ((DataInput)input).readByte();
            boolean bl = hasPassword = hasPasswordByte == 1;
            if (!hasPassword && hasPasswordByte != 0) {
                throw new IllegalStateException("hasPassword boolean is corrupt: " + String.format(Locale.ROOT, "%02x", hasPasswordByte));
            }
            String type = input.readString();
            String secretKeyAlgo = input.readString();
            byte[] keystoreBytes = new byte[input.readInt()];
            ((DataInput)input).readBytes(keystoreBytes, 0, keystoreBytes.length);
            CodecUtil.checkFooter(input);
            KeyStoreWrapper keyStoreWrapper = new KeyStoreWrapper(hasPassword, type, secretKeyAlgo, keystoreBytes);
            return keyStoreWrapper;
        }
    }

    @Override
    public boolean isLoaded() {
        return this.keystore.get() != null;
    }

    public boolean hasPassword() {
        return this.hasPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrypt(char[] password) throws GeneralSecurityException, IOException {
        if (this.keystore.get() != null) {
            throw new IllegalStateException("Keystore has already been decrypted");
        }
        this.keystore.set(KeyStore.getInstance(this.type));
        try (ByteArrayInputStream in = new ByteArrayInputStream(this.keystoreBytes);){
            this.keystore.get().load(in, password);
        }
        finally {
            Arrays.fill(this.keystoreBytes, (byte)0);
        }
        this.keystorePassword.set(new KeyStore.PasswordProtection(password));
        Arrays.fill(password, '\u0000');
        Enumeration<String> aliases = this.keystore.get().aliases();
        while (aliases.hasMoreElements()) {
            this.settingNames.add(aliases.nextElement());
        }
    }

    void save(Path configDir) throws Exception {
        char[] password = this.keystorePassword.get().getPassword();
        SimpleFSDirectory directory = new SimpleFSDirectory(configDir);
        String tmpFile = "elasticsearch.keystore.tmp";
        try (IndexOutput output = directory.createOutput(tmpFile, IOContext.DEFAULT);){
            CodecUtil.writeHeader(output, KEYSTORE_FILENAME, 1);
            output.writeByte(password.length == 0 ? (byte)0 : 1);
            output.writeString(this.type);
            output.writeString(this.secretFactory.getAlgorithm());
            ByteArrayOutputStream keystoreBytesStream = new ByteArrayOutputStream();
            this.keystore.get().store(keystoreBytesStream, password);
            byte[] keystoreBytes = keystoreBytesStream.toByteArray();
            output.writeInt(keystoreBytes.length);
            output.writeBytes(keystoreBytes, keystoreBytes.length);
            CodecUtil.writeFooter(output);
        }
        Path keystoreFile = KeyStoreWrapper.keystorePath(configDir);
        Files.move(configDir.resolve(tmpFile), keystoreFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        PosixFileAttributeView attrs = Files.getFileAttributeView(keystoreFile, PosixFileAttributeView.class, new LinkOption[0]);
        if (attrs != null) {
            attrs.setPermissions(PosixFilePermissions.fromString("rw-------"));
        }
    }

    @Override
    public Set<String> getSettingNames() {
        return this.settingNames;
    }

    @Override
    public SecureString getString(String setting) throws GeneralSecurityException {
        KeyStore.Entry entry = this.keystore.get().getEntry(setting, this.keystorePassword.get());
        if (!(entry instanceof KeyStore.SecretKeyEntry)) {
            throw new IllegalStateException("Secret setting " + setting + " is not a string");
        }
        KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)entry;
        PBEKeySpec keySpec = (PBEKeySpec)this.secretFactory.getKeySpec(secretKeyEntry.getSecretKey(), PBEKeySpec.class);
        SecureString value = new SecureString(keySpec.getPassword());
        keySpec.clearPassword();
        return value;
    }

    void setString(String setting, char[] value) throws GeneralSecurityException {
        if (!ASCII_ENCODER.canEncode((CharSequence)CharBuffer.wrap(value))) {
            throw new IllegalArgumentException("Value must be ascii");
        }
        SecretKey secretKey = this.secretFactory.generateSecret(new PBEKeySpec(value));
        this.keystore.get().setEntry(setting, new KeyStore.SecretKeyEntry(secretKey), this.keystorePassword.get());
        this.settingNames.add(setting);
    }

    void remove(String setting) throws KeyStoreException {
        this.keystore.get().deleteEntry(setting);
        this.settingNames.remove(setting);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.keystorePassword.get() != null) {
                this.keystorePassword.get().destroy();
            }
        }
        catch (DestroyFailedException e) {
            throw new IOException(e);
        }
    }
}

