/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class SnapshotInProgressAllocationDecider
extends AllocationDecider {
    public static final String NAME = "snapshot_in_progress";
    public static final Setting<Boolean> CLUSTER_ROUTING_ALLOCATION_SNAPSHOT_RELOCATION_ENABLED_SETTING = Setting.boolSetting("cluster.routing.allocation.snapshot.relocation_enabled", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile boolean enableRelocation = false;

    public SnapshotInProgressAllocationDecider() {
        this(Settings.Builder.EMPTY_SETTINGS);
    }

    public SnapshotInProgressAllocationDecider(Settings settings) {
        this(settings, new ClusterSettings(settings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS));
    }

    public SnapshotInProgressAllocationDecider(Settings settings, ClusterSettings clusterSettings) {
        super(settings);
        this.enableRelocation = CLUSTER_ROUTING_ALLOCATION_SNAPSHOT_RELOCATION_ENABLED_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_ROUTING_ALLOCATION_SNAPSHOT_RELOCATION_ENABLED_SETTING, this::setEnableRelocation);
    }

    private void setEnableRelocation(boolean enableRelocation) {
        this.enableRelocation = enableRelocation;
    }

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        return this.canMove(shardRouting, allocation);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canMove(shardRouting, allocation);
    }

    private Decision canMove(ShardRouting shardRouting, RoutingAllocation allocation) {
        if (!this.enableRelocation && shardRouting.primary()) {
            SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)allocation.custom("snapshots");
            if (snapshotsInProgress == null) {
                return allocation.decision(Decision.YES, NAME, "no snapshots are currently running", new Object[0]);
            }
            for (SnapshotsInProgress.Entry snapshot : snapshotsInProgress.entries()) {
                SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus = snapshot.shards().get(shardRouting.shardId());
                if (shardSnapshotStatus == null || shardSnapshotStatus.state().completed() || shardSnapshotStatus.nodeId() == null || !shardSnapshotStatus.nodeId().equals(shardRouting.currentNodeId())) continue;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Preventing snapshotted shard [{}] from being moved away from node [{}]", (Object)shardRouting.shardId(), (Object)shardSnapshotStatus.nodeId());
                }
                return allocation.decision(Decision.THROTTLE, NAME, "waiting for snapshotting of shard [%s] to complete on this node [%s]", shardRouting.shardId(), shardSnapshotStatus.nodeId());
            }
        }
        return allocation.decision(Decision.YES, NAME, "the shard is not being snapshotted", new Object[0]);
    }
}

