/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.cursors.IntObjectCursor;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;

public final class ActiveShardCount
implements Writeable {
    private static final int ACTIVE_SHARD_COUNT_DEFAULT = -2;
    private static final int ALL_ACTIVE_SHARDS = -1;
    public static final ActiveShardCount DEFAULT = new ActiveShardCount(-2);
    public static final ActiveShardCount ALL = new ActiveShardCount(-1);
    public static final ActiveShardCount NONE = new ActiveShardCount(0);
    public static final ActiveShardCount ONE = new ActiveShardCount(1);
    private final int value;

    private ActiveShardCount(int value) {
        this.value = value;
    }

    public static ActiveShardCount from(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("shard count cannot be a negative value");
        }
        return ActiveShardCount.get(value);
    }

    public boolean validate(int numberOfReplicas) {
        assert (numberOfReplicas >= 0);
        return this.value <= numberOfReplicas + 1;
    }

    private static ActiveShardCount get(int value) {
        switch (value) {
            case -2: {
                return DEFAULT;
            }
            case -1: {
                return ALL;
            }
            case 1: {
                return ONE;
            }
            case 0: {
                return NONE;
            }
        }
        assert (value > 1);
        return new ActiveShardCount(value);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.value);
    }

    public static ActiveShardCount readFrom(StreamInput in) throws IOException {
        return ActiveShardCount.get(in.readInt());
    }

    public static ActiveShardCount parseString(String str) {
        int val;
        if (str == null) {
            return DEFAULT;
        }
        if (str.equals("all")) {
            return ALL;
        }
        try {
            val = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("cannot parse ActiveShardCount[" + str + "]", e);
        }
        return ActiveShardCount.from(val);
    }

    public boolean enoughShardsActive(int activeShardCount) {
        if (this.value < 0) {
            throw new IllegalStateException("not enough information to resolve to shard count");
        }
        if (activeShardCount < 0) {
            throw new IllegalArgumentException("activeShardCount cannot be negative");
        }
        return this.value <= activeShardCount;
    }

    public boolean enoughShardsActive(ClusterState clusterState, String indexName) {
        if (this == NONE) {
            return true;
        }
        IndexMetaData indexMetaData = clusterState.metaData().index(indexName);
        if (indexMetaData == null) {
            return true;
        }
        IndexRoutingTable indexRoutingTable = clusterState.routingTable().index(indexName);
        assert (indexRoutingTable != null);
        if (!indexRoutingTable.allPrimaryShardsActive()) {
            return false;
        }
        ActiveShardCount waitForActiveShards = this;
        if (waitForActiveShards == DEFAULT) {
            waitForActiveShards = IndexMetaData.SETTING_WAIT_FOR_ACTIVE_SHARDS.get(indexMetaData.getSettings());
        }
        for (IntObjectCursor<IndexShardRoutingTable> intObjectCursor : indexRoutingTable.getShards()) {
            if (waitForActiveShards.enoughShardsActive((IndexShardRoutingTable)intObjectCursor.value)) continue;
            return false;
        }
        return true;
    }

    public boolean enoughShardsActive(IndexShardRoutingTable shardRoutingTable) {
        int activeShardCount = shardRoutingTable.activeShards().size();
        if (this == ALL) {
            return activeShardCount == shardRoutingTable.replicaShards().size() + 1;
        }
        if (this == DEFAULT) {
            return activeShardCount >= 1;
        }
        return activeShardCount >= this.value;
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActiveShardCount that = (ActiveShardCount)o;
        return this.value == that.value;
    }

    public String toString() {
        switch (this.value) {
            case -1: {
                return "ALL";
            }
            case -2: {
                return "DEFAULT";
            }
        }
        return Integer.toString(this.value);
    }
}

