/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.search.dfs.AggregatedDfs;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchTransportRequest;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.transport.Transport;

final class SearchDfsQueryThenFetchAsyncAction
extends AbstractSearchAsyncAction<DfsSearchResult> {
    SearchDfsQueryThenFetchAsyncAction(Logger logger, SearchTransportService searchTransportService, Function<String, Transport.Connection> nodeIdToConnection, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, SearchPhaseController searchPhaseController, Executor executor, SearchRequest request, ActionListener<SearchResponse> listener, GroupShardsIterator shardsIts, long startTime, long clusterStateVersion, SearchTask task) {
        super(logger, searchTransportService, nodeIdToConnection, aliasFilter, concreteIndexBoosts, searchPhaseController, executor, request, listener, shardsIts, startTime, clusterStateVersion, task);
    }

    @Override
    protected String initialPhaseName() {
        return "dfs";
    }

    @Override
    protected void sendExecuteFirstPhase(Transport.Connection connection, ShardSearchTransportRequest request, ActionListener<DfsSearchResult> listener) {
        this.searchTransportService.sendExecuteDfs(connection, request, this.task, listener);
    }

    @Override
    protected CheckedRunnable<Exception> getNextPhase(AtomicArray<DfsSearchResult> initialResults) {
        return new DfsQueryPhase(initialResults, this.searchPhaseController, queryResults -> new AbstractSearchAsyncAction.FetchPhase((AtomicArray<QuerySearchResultProvider>)queryResults, this.searchPhaseController));
    }

    private final class DfsQueryPhase
    implements CheckedRunnable<Exception> {
        private final AtomicArray<QuerySearchResultProvider> queryResult;
        private final SearchPhaseController searchPhaseController;
        private final AtomicArray<DfsSearchResult> firstResults;
        private final Function<AtomicArray<QuerySearchResultProvider>, CheckedRunnable<Exception>> nextPhaseFactory;

        DfsQueryPhase(AtomicArray<DfsSearchResult> firstResults, SearchPhaseController searchPhaseController, Function<AtomicArray<QuerySearchResultProvider>, CheckedRunnable<Exception>> nextPhaseFactory) {
            this.queryResult = new AtomicArray(firstResults.length());
            this.searchPhaseController = searchPhaseController;
            this.firstResults = firstResults;
            this.nextPhaseFactory = nextPhaseFactory;
        }

        @Override
        public void run() throws Exception {
            AggregatedDfs dfs = this.searchPhaseController.aggregateDfs(this.firstResults);
            final AbstractSearchAsyncAction.CountedCollector<QuerySearchResultProvider> counter = new AbstractSearchAsyncAction.CountedCollector<QuerySearchResultProvider>(this.queryResult, this.firstResults.asList().size(), successfulOps -> {
                if (successfulOps == 0) {
                    SearchDfsQueryThenFetchAsyncAction.this.listener.onFailure(new SearchPhaseExecutionException("query", "all shards failed", SearchDfsQueryThenFetchAsyncAction.this.buildShardFailures()));
                } else {
                    SearchDfsQueryThenFetchAsyncAction.this.executePhase("fetch", this.nextPhaseFactory.apply(this.queryResult), null);
                }
            });
            for (AtomicArray.Entry<DfsSearchResult> entry : this.firstResults.asList()) {
                final DfsSearchResult dfsResult = (DfsSearchResult)entry.value;
                final int shardIndex = entry.index;
                final Transport.Connection connection = (Transport.Connection)SearchDfsQueryThenFetchAsyncAction.this.nodeIdToConnection.apply(dfsResult.shardTarget().getNodeId());
                final QuerySearchRequest querySearchRequest = new QuerySearchRequest(SearchDfsQueryThenFetchAsyncAction.this.request, dfsResult.id(), dfs);
                SearchDfsQueryThenFetchAsyncAction.this.searchTransportService.sendExecuteQuery(connection, querySearchRequest, SearchDfsQueryThenFetchAsyncAction.this.task, new ActionListener<QuerySearchResult>(){

                    @Override
                    public void onResponse(QuerySearchResult result) {
                        counter.onResult(shardIndex, result, dfsResult.shardTarget());
                    }

                    @Override
                    public void onFailure(Exception e) {
                        try {
                            if (SearchDfsQueryThenFetchAsyncAction.this.logger.isDebugEnabled()) {
                                SearchDfsQueryThenFetchAsyncAction.this.logger.debug(() -> new ParameterizedMessage("[{}] Failed to execute query phase", (Object)querySearchRequest.id()), (Throwable)e);
                            }
                            counter.onFailure(shardIndex, dfsResult.shardTarget(), e);
                        }
                        finally {
                            SearchDfsQueryThenFetchAsyncAction.this.sendReleaseSearchContext(querySearchRequest.id(), connection);
                        }
                    }
                });
            }
        }
    }
}

