/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class BulkItemRequest
implements Streamable {
    private int id;
    private DocWriteRequest request;
    private volatile BulkItemResponse primaryResponse;
    private volatile boolean ignoreOnReplica;

    BulkItemRequest() {
    }

    public BulkItemRequest(int id, DocWriteRequest request) {
        assert (request instanceof IndicesRequest);
        this.id = id;
        this.request = request;
    }

    public int id() {
        return this.id;
    }

    public DocWriteRequest request() {
        return this.request;
    }

    public String index() {
        assert (this.request.indices().length == 1);
        return this.request.indices()[0];
    }

    BulkItemResponse getPrimaryResponse() {
        return this.primaryResponse;
    }

    void setPrimaryResponse(BulkItemResponse primaryResponse) {
        this.primaryResponse = primaryResponse;
    }

    void setIgnoreOnReplica() {
        this.ignoreOnReplica = true;
    }

    boolean isIgnoreOnReplica() {
        return this.ignoreOnReplica;
    }

    public static BulkItemRequest readBulkItem(StreamInput in) throws IOException {
        BulkItemRequest item = new BulkItemRequest();
        item.readFrom(in);
        return item;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.id = in.readVInt();
        this.request = DocWriteRequest.readDocumentRequest(in);
        if (in.readBoolean()) {
            this.primaryResponse = BulkItemResponse.readBulkItem(in);
        }
        this.ignoreOnReplica = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        DocWriteRequest.writeDocumentRequest(out, this.request);
        out.writeOptionalStreamable(this.primaryResponse);
        out.writeBoolean(this.ignoreOnReplica);
    }
}

