/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shrink;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ObjectParser;

public class ShrinkRequest
extends AcknowledgedRequest<ShrinkRequest>
implements IndicesRequest {
    public static final ObjectParser<ShrinkRequest, Void> PARSER = new ObjectParser("shrink_request", null);
    private CreateIndexRequest shrinkIndexRequest;
    private String sourceIndex;

    ShrinkRequest() {
    }

    public ShrinkRequest(String targetIndex, String sourceindex) {
        this.shrinkIndexRequest = new CreateIndexRequest(targetIndex);
        this.sourceIndex = sourceindex;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException;
        ActionRequestValidationException actionRequestValidationException = validationException = this.shrinkIndexRequest == null ? null : this.shrinkIndexRequest.validate();
        if (this.sourceIndex == null) {
            validationException = ValidateActions.addValidationError("source index is missing", validationException);
        }
        if (this.shrinkIndexRequest == null) {
            validationException = ValidateActions.addValidationError("shrink index request is missing", validationException);
        }
        return validationException;
    }

    public void setSourceIndex(String index) {
        this.sourceIndex = index;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shrinkIndexRequest = new CreateIndexRequest();
        this.shrinkIndexRequest.readFrom(in);
        this.sourceIndex = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shrinkIndexRequest.writeTo(out);
        out.writeString(this.sourceIndex);
    }

    @Override
    public String[] indices() {
        return new String[]{this.sourceIndex};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.lenientExpandOpen();
    }

    public void setShrinkIndex(CreateIndexRequest shrinkIndexRequest) {
        this.shrinkIndexRequest = Objects.requireNonNull(shrinkIndexRequest, "shrink index request must not be null");
    }

    public CreateIndexRequest getShrinkIndexRequest() {
        return this.shrinkIndexRequest;
    }

    public String getSourceIndex() {
        return this.sourceIndex;
    }

    public void setWaitForActiveShards(ActiveShardCount waitForActiveShards) {
        this.getShrinkIndexRequest().waitForActiveShards(waitForActiveShards);
    }

    public void setWaitForActiveShards(int waitForActiveShards) {
        this.setWaitForActiveShards(ActiveShardCount.from(waitForActiveShards));
    }

    static {
        PARSER.declareField((parser, request, context) -> request.getShrinkIndexRequest().settings(parser.map()), new ParseField("settings", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareField((parser, request, context) -> request.getShrinkIndexRequest().aliases(parser.map()), new ParseField("aliases", new String[0]), ObjectParser.ValueType.OBJECT);
    }
}

