/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store;

import java.util.Arrays;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.FileSwitchDirectory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.MMapDirectory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.NIOFSDirectory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.SimpleFSDirectory;

public final class StoreUtils {
    private StoreUtils() {
    }

    public static String toString(Directory directory) {
        if (directory instanceof NIOFSDirectory) {
            NIOFSDirectory niofsDirectory = (NIOFSDirectory)directory;
            return "niofs(" + niofsDirectory.getDirectory() + ")";
        }
        if (directory instanceof MMapDirectory) {
            MMapDirectory mMapDirectory = (MMapDirectory)directory;
            return "mmapfs(" + mMapDirectory.getDirectory() + ")";
        }
        if (directory instanceof SimpleFSDirectory) {
            SimpleFSDirectory simpleFSDirectory = (SimpleFSDirectory)directory;
            return "simplefs(" + simpleFSDirectory.getDirectory() + ")";
        }
        if (directory instanceof FileSwitchDirectory) {
            FileSwitchDirectory fileSwitchDirectory = (FileSwitchDirectory)directory;
            return "default(" + StoreUtils.toString(fileSwitchDirectory.getPrimaryDir()) + "," + StoreUtils.toString(fileSwitchDirectory.getSecondaryDir()) + ")";
        }
        return directory.toString();
    }

    public static String toString(Directory[] directories) {
        Object[] strings = new String[directories.length];
        for (int i = 0; i < directories.length; ++i) {
            strings[i] = StoreUtils.toString(directories[i]);
        }
        return Arrays.toString(strings);
    }
}

