/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.geopoint.search;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.PointValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.MultiTermQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.geopoint.search.GeoPointMultiTermQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.util.GeoRelationUtils;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.SloppyMath;

class GeoPointInBBoxQueryImpl
extends GeoPointMultiTermQuery {
    GeoPointInBBoxQueryImpl(String field, GeoPointField.TermEncoding termEncoding, double minLat, double maxLat, double minLon, double maxLon) {
        super(field, termEncoding, minLat, maxLat, minLon, maxLon);
    }

    @Override
    public void setRewriteMethod(MultiTermQuery.RewriteMethod method) {
        throw new UnsupportedOperationException("cannot change rewrite method");
    }

    @Override
    protected short computeMaxShift() {
        double midLat = (this.minLat + this.maxLat) * 0.5;
        double midLon = (this.minLon + this.maxLon) * 0.5;
        int shiftFactor = SloppyMath.haversinMeters(this.minLat, this.minLon, midLat, midLon) > 1000000.0 ? 5 : 4;
        return (short)(9 * shiftFactor);
    }

    @Override
    protected GeoPointMultiTermQuery.CellComparator newCellComparator() {
        return new GeoPointInBBoxCellComparator(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointInBBoxQueryImpl that = (GeoPointInBBoxQueryImpl)o;
        if (Double.compare(that.minLat, this.minLat) != 0) {
            return false;
        }
        if (Double.compare(that.maxLat, this.maxLat) != 0) {
            return false;
        }
        if (Double.compare(that.minLon, this.minLon) != 0) {
            return false;
        }
        return Double.compare(that.maxLon, this.maxLon) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.minLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.getField().equals(field)) {
            sb.append(" field=");
            sb.append(this.getField());
            sb.append(':');
        }
        return sb.append(" Lower Left: [").append(this.minLat).append(',').append(this.minLon).append(']').append(" Upper Right: [").append(this.maxLat).append(',').append(this.maxLon).append("]").toString();
    }

    private final class GeoPointInBBoxCellComparator
    extends GeoPointMultiTermQuery.CellComparator {
        GeoPointInBBoxCellComparator(GeoPointMultiTermQuery query) {
            super(query);
        }

        @Override
        protected boolean cellCrosses(double minLat, double maxLat, double minLon, double maxLon) {
            return GeoRelationUtils.rectCrosses(minLat, maxLat, minLon, maxLon, GeoPointInBBoxQueryImpl.this.minLat, GeoPointInBBoxQueryImpl.this.maxLat, GeoPointInBBoxQueryImpl.this.minLon, GeoPointInBBoxQueryImpl.this.maxLon);
        }

        @Override
        protected boolean cellWithin(double minLat, double maxLat, double minLon, double maxLon) {
            return GeoRelationUtils.rectWithin(minLat, maxLat, minLon, maxLon, GeoPointInBBoxQueryImpl.this.minLat, GeoPointInBBoxQueryImpl.this.maxLat, GeoPointInBBoxQueryImpl.this.minLon, GeoPointInBBoxQueryImpl.this.maxLon);
        }

        @Override
        protected boolean cellIntersectsShape(double minLat, double maxLat, double minLon, double maxLon) {
            return this.cellIntersectsMBR(minLat, maxLat, minLon, maxLon);
        }

        @Override
        protected PointValues.Relation relate(double minLat, double maxLat, double minLon, double maxLon) {
            if (GeoRelationUtils.rectCrosses(minLat, maxLat, minLon, maxLon, GeoPointInBBoxQueryImpl.this.minLat, GeoPointInBBoxQueryImpl.this.maxLat, GeoPointInBBoxQueryImpl.this.minLon, GeoPointInBBoxQueryImpl.this.maxLon)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
            if (GeoRelationUtils.rectWithin(minLat, maxLat, minLon, maxLon, GeoPointInBBoxQueryImpl.this.minLat, GeoPointInBBoxQueryImpl.this.maxLat, GeoPointInBBoxQueryImpl.this.minLon, GeoPointInBBoxQueryImpl.this.maxLon)) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
            return PointValues.Relation.CELL_OUTSIDE_QUERY;
        }

        @Override
        protected boolean postFilter(double lat, double lon) {
            return GeoRelationUtils.pointInRectPrecise(lat, lon, GeoPointInBBoxQueryImpl.this.minLat, GeoPointInBBoxQueryImpl.this.maxLat, GeoPointInBBoxQueryImpl.this.minLon, GeoPointInBBoxQueryImpl.this.maxLon);
        }
    }
}

