/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.bbox;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.function.FunctionValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.function.ValueSource;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.function.docvalues.DoubleDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.IndexSearcher;
import org.locationtech.spatial4j.shape.Rectangle;

public abstract class BBoxSimilarityValueSource
extends ValueSource {
    private final ValueSource bboxValueSource;

    public BBoxSimilarityValueSource(ValueSource bboxValueSource) {
        this.bboxValueSource = bboxValueSource;
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.bboxValueSource.createWeight(context, searcher);
    }

    @Override
    public String description() {
        return this.getClass().getSimpleName() + "(" + this.bboxValueSource.description() + "," + this.similarityDescription() + ")";
    }

    protected abstract String similarityDescription();

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues shapeValues = this.bboxValueSource.getValues(context, readerContext);
        return new DoubleDocValues(this){

            @Override
            public double doubleVal(int doc) {
                Rectangle rect = (Rectangle)shapeValues.objectVal(doc);
                return rect == null ? 0.0 : BBoxSimilarityValueSource.this.score(rect, null);
            }

            @Override
            public boolean exists(int doc) {
                return shapeValues.exists(doc);
            }

            @Override
            public Explanation explain(int doc) {
                Rectangle rect = (Rectangle)shapeValues.objectVal(doc);
                if (rect == null) {
                    return Explanation.noMatch("no rect", new Explanation[0]);
                }
                AtomicReference<Explanation> explanation = new AtomicReference<Explanation>();
                BBoxSimilarityValueSource.this.score(rect, explanation);
                return explanation.get();
            }
        };
    }

    protected abstract double score(Rectangle var1, AtomicReference<Explanation> var2);

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BBoxSimilarityValueSource that = (BBoxSimilarityValueSource)o;
        return this.bboxValueSource.equals(that.bboxValueSource);
    }

    @Override
    public int hashCode() {
        return this.bboxValueSource.hashCode();
    }
}

