/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.document.Field;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.function.ValueSource;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.function.valuesource.ReciprocalFloatFunction;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.spatial.query.SpatialArgs;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

public abstract class SpatialStrategy {
    protected final SpatialContext ctx;
    private final String fieldName;

    public SpatialStrategy(SpatialContext ctx, String fieldName) {
        if (ctx == null) {
            throw new IllegalArgumentException("ctx is required");
        }
        this.ctx = ctx;
        if (fieldName == null || fieldName.length() == 0) {
            throw new IllegalArgumentException("fieldName is required");
        }
        this.fieldName = fieldName;
    }

    public SpatialContext getSpatialContext() {
        return this.ctx;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public abstract Field[] createIndexableFields(Shape var1);

    public ValueSource makeDistanceValueSource(Point queryPoint) {
        return this.makeDistanceValueSource(queryPoint, 1.0);
    }

    public abstract ValueSource makeDistanceValueSource(Point var1, double var2);

    public abstract Query makeQuery(SpatialArgs var1);

    public final ValueSource makeRecipDistanceValueSource(Shape queryShape) {
        Rectangle bbox = queryShape.getBoundingBox();
        double diagonalDist = this.ctx.getDistCalc().distance(this.ctx.makePoint(bbox.getMinX(), bbox.getMinY()), bbox.getMaxX(), bbox.getMaxY());
        double distToEdge = diagonalDist * 0.5;
        float c = (float)distToEdge * 0.1f;
        return new ReciprocalFloatFunction(this.makeDistanceValueSource(queryShape.getCenter(), 1.0), 1.0f, c, c);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " field:" + this.fieldName + " ctx=" + this.ctx;
    }
}

