/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.CommonTermsQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.PrefixQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TermQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.highlight.Snippet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight.UnifiedHighlighter;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lucene.all.AllTermQuery;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.elasticsearch.common.lucene.search.function.FiltersFunctionScoreQuery;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;

public class CustomUnifiedHighlighter
extends UnifiedHighlighter {
    private static final Snippet[] EMPTY_SNIPPET = new Snippet[0];
    private final String fieldValue;
    private final PassageFormatter passageFormatter;
    private final BreakIterator breakIterator;
    private final boolean returnNonHighlightedSnippets;

    public CustomUnifiedHighlighter(IndexSearcher searcher, Analyzer analyzer, PassageFormatter passageFormatter, @Nullable BreakIterator breakIterator, String fieldValue, boolean returnNonHighlightedSnippets) {
        super(searcher, analyzer);
        this.breakIterator = breakIterator;
        this.passageFormatter = passageFormatter;
        this.fieldValue = fieldValue;
        this.returnNonHighlightedSnippets = returnNonHighlightedSnippets;
    }

    public Snippet[] highlightField(String field, Query query, int docId, int maxPassages) throws IOException {
        Map<String, Object[]> fieldsAsObjects = super.highlightFieldsAsObjects(new String[]{field}, query, new int[]{docId}, new int[]{maxPassages});
        Object[] snippetObjects = fieldsAsObjects.get(field);
        if (snippetObjects != null) {
            assert (snippetObjects.length == 1);
            Object snippetObject = snippetObjects[0];
            if (snippetObject != null && snippetObject instanceof Snippet[]) {
                return (Snippet[])snippetObject;
            }
        }
        return EMPTY_SNIPPET;
    }

    @Override
    protected List<CharSequence[]> loadFieldValues(String[] fields, DocIdSetIterator docIter, int cacheCharsThreshold) throws IOException {
        return Collections.singletonList(new String[]{this.fieldValue});
    }

    @Override
    protected BreakIterator getBreakIterator(String field) {
        if (this.breakIterator != null) {
            return this.breakIterator;
        }
        return super.getBreakIterator(field);
    }

    @Override
    protected PassageFormatter getFormatter(String field) {
        return this.passageFormatter;
    }

    @Override
    protected int getMaxNoHighlightPassages(String field) {
        if (this.returnNonHighlightedSnippets) {
            return 1;
        }
        return 0;
    }

    @Override
    protected Collection<Query> preMultiTermQueryRewrite(Query query) {
        return this.rewriteCustomQuery(query);
    }

    @Override
    protected Collection<Query> preSpanQueryRewrite(Query query) {
        return this.rewriteCustomQuery(query);
    }

    private Collection<Query> rewriteCustomQuery(Query query) {
        if (query instanceof MultiPhrasePrefixQuery) {
            MultiPhrasePrefixQuery mpq = (MultiPhrasePrefixQuery)query;
            Term[][] terms = mpq.getTerms();
            int[] positions = mpq.getPositions();
            SpanQuery[] positionSpanQueries = new SpanQuery[positions.length];
            int sizeMinus1 = terms.length - 1;
            for (int i = 0; i < positions.length; ++i) {
                SpanQuery[] innerQueries = new SpanQuery[terms[i].length];
                for (int j = 0; j < terms[i].length; ++j) {
                    innerQueries[j] = i == sizeMinus1 ? new SpanMultiTermQueryWrapper<PrefixQuery>(new PrefixQuery(terms[i][j])) : new SpanTermQuery(terms[i][j]);
                }
                positionSpanQueries[i] = innerQueries.length > 1 ? new SpanOrQuery(innerQueries) : innerQueries[0];
            }
            int positionGaps = 0;
            if (positions.length >= 2) {
                positionGaps = Math.max(0, positions[positions.length - 1] - positions[0] - positions.length + 1);
            }
            boolean inorder = mpq.getSlop() == 0;
            return Collections.singletonList(new SpanNearQuery(positionSpanQueries, mpq.getSlop() + positionGaps, inorder));
        }
        if (query instanceof CommonTermsQuery) {
            CommonTermsQuery ctq = (CommonTermsQuery)query;
            ArrayList<Query> tqs = new ArrayList<Query>();
            for (Term term : ctq.getTerms()) {
                tqs.add(new TermQuery(term));
            }
            return tqs;
        }
        if (query instanceof AllTermQuery) {
            AllTermQuery atq = (AllTermQuery)query;
            return Collections.singletonList(new TermQuery(atq.getTerm()));
        }
        if (query instanceof FunctionScoreQuery) {
            return Collections.singletonList(((FunctionScoreQuery)query).getSubQuery());
        }
        if (query instanceof FiltersFunctionScoreQuery) {
            return Collections.singletonList(((FiltersFunctionScoreQuery)query).getSubQuery());
        }
        return null;
    }
}

