/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.PostingsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.PriorityQueue;

final class CompositeOffsetsPostingsEnum
extends PostingsEnum {
    private final int docId;
    private final int freq;
    private final PriorityQueue<BoundsCheckingPostingsEnum> queue;
    private boolean firstPositionConsumed = false;

    CompositeOffsetsPostingsEnum(List<PostingsEnum> postingsEnums) throws IOException {
        this.queue = new PriorityQueue<BoundsCheckingPostingsEnum>(postingsEnums.size()){

            @Override
            protected boolean lessThan(BoundsCheckingPostingsEnum a, BoundsCheckingPostingsEnum b) {
                try {
                    return a.postingsEnum.startOffset() < b.postingsEnum.startOffset();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        int freqAdd = 0;
        for (PostingsEnum postingsEnum : postingsEnums) {
            this.queue.add(new BoundsCheckingPostingsEnum(postingsEnum));
            freqAdd += postingsEnum.freq();
        }
        this.freq = freqAdd;
        this.docId = this.queue.top().postingsEnum.docID();
    }

    @Override
    public int freq() throws IOException {
        return this.freq;
    }

    @Override
    public int nextPosition() throws IOException {
        if (!this.firstPositionConsumed) {
            this.firstPositionConsumed = true;
        } else {
            if (this.queue.size() == 0) {
                throw new IllegalStateException("nextPosition called too many times");
            }
            if (this.queue.top().nextPosition()) {
                this.queue.updateTop();
            } else {
                this.queue.pop();
            }
        }
        assert (this.queue.size() > 0);
        return -1;
    }

    @Override
    public int startOffset() throws IOException {
        return this.queue.top().postingsEnum.startOffset();
    }

    @Override
    public int endOffset() throws IOException {
        return this.queue.top().postingsEnum.endOffset();
    }

    @Override
    public BytesRef getPayload() throws IOException {
        return this.queue.top().postingsEnum.getPayload();
    }

    @Override
    public int docID() {
        return this.docId;
    }

    @Override
    public int nextDoc() throws IOException {
        return Integer.MAX_VALUE;
    }

    @Override
    public int advance(int target) throws IOException {
        return Integer.MAX_VALUE;
    }

    @Override
    public long cost() {
        return 1L;
    }

    private static final class BoundsCheckingPostingsEnum {
        private final PostingsEnum postingsEnum;
        private int remainingPositions;

        BoundsCheckingPostingsEnum(PostingsEnum postingsEnum) throws IOException {
            this.postingsEnum = postingsEnum;
            this.remainingPositions = postingsEnum.freq();
            this.nextPosition();
        }

        private boolean nextPosition() throws IOException {
            if (this.remainingPositions-- > 0) {
                this.postingsEnum.nextPosition();
                return true;
            }
            return false;
        }
    }
}

