/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.suggest.document;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.CollectionTerminatedException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SimpleCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.suggest.document.SuggestScoreDocPriorityQueue;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.suggest.document.TopSuggestDocs;

public class TopSuggestDocsCollector
extends SimpleCollector {
    private final SuggestScoreDocPriorityQueue priorityQueue;
    private final int num;
    protected int docBase;

    public TopSuggestDocsCollector(int num) {
        if (num <= 0) {
            throw new IllegalArgumentException("'num' must be > 0");
        }
        this.num = num;
        this.priorityQueue = new SuggestScoreDocPriorityQueue(num);
    }

    public int getCountToCollect() {
        return this.num;
    }

    @Override
    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docBase = context.docBase;
    }

    public void collect(int docID, CharSequence key, CharSequence context, float score) throws IOException {
        TopSuggestDocs.SuggestScoreDoc current = new TopSuggestDocs.SuggestScoreDoc(this.docBase + docID, key, context, score);
        if (current == this.priorityQueue.insertWithOverflow(current)) {
            throw new CollectionTerminatedException();
        }
    }

    public TopSuggestDocs get() throws IOException {
        TopSuggestDocs.SuggestScoreDoc[] suggestScoreDocs = this.priorityQueue.getResults();
        if (suggestScoreDocs.length > 0) {
            return new TopSuggestDocs(suggestScoreDocs.length, suggestScoreDocs, suggestScoreDocs[0].score);
        }
        return TopSuggestDocs.EMPTY;
    }

    @Override
    public void collect(int doc) throws IOException {
    }

    @Override
    public boolean needsScores() {
        return true;
    }
}

