/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.suggest.document;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStreamToAutomaton;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.AttributeImpl;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.AttributeReflector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.CharsRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.IntsRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.automaton.Automaton;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.automaton.FiniteStringsIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.automaton.LimitedFiniteStringsIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.automaton.Operations;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.automaton.Transition;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.fst.Util;

public final class CompletionTokenStream
extends TokenStream {
    private final PayloadAttribute payloadAttr = this.addAttribute(PayloadAttribute.class);
    private final BytesRefBuilderTermAttribute bytesAtt = this.addAttribute(BytesRefBuilderTermAttribute.class);
    final TokenStream inputTokenStream;
    final boolean preserveSep;
    final boolean preservePositionIncrements;
    final int maxGraphExpansions;
    private FiniteStringsIterator finiteStrings;
    private BytesRef payload;
    private CharTermAttribute charTermAttribute;

    CompletionTokenStream(TokenStream inputTokenStream) {
        this(inputTokenStream, true, true, 10000);
    }

    CompletionTokenStream(TokenStream inputTokenStream, boolean preserveSep, boolean preservePositionIncrements, int maxGraphExpansions) {
        this.inputTokenStream = inputTokenStream;
        this.preserveSep = preserveSep;
        this.preservePositionIncrements = preservePositionIncrements;
        this.maxGraphExpansions = maxGraphExpansions;
    }

    public void setPayload(BytesRef payload) {
        this.payload = payload;
    }

    @Override
    public boolean incrementToken() throws IOException {
        IntsRef string;
        this.clearAttributes();
        if (this.finiteStrings == null) {
            Automaton automaton = this.toAutomaton();
            this.finiteStrings = new LimitedFiniteStringsIterator(automaton, this.maxGraphExpansions);
        }
        if ((string = this.finiteStrings.next()) == null) {
            return false;
        }
        Util.toBytesRef(string, this.bytesAtt.builder());
        if (this.charTermAttribute != null) {
            this.charTermAttribute.setLength(0);
            this.charTermAttribute.append(this.bytesAtt.toUTF16());
        }
        if (this.payload != null) {
            this.payloadAttr.setPayload(this.payload);
        }
        return true;
    }

    @Override
    public void end() throws IOException {
        super.end();
        if (this.finiteStrings == null) {
            this.inputTokenStream.end();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.finiteStrings == null) {
            this.inputTokenStream.close();
        }
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        if (this.hasAttribute(CharTermAttribute.class)) {
            this.charTermAttribute = this.getAttribute(CharTermAttribute.class);
        }
        this.finiteStrings = null;
    }

    public Automaton toAutomaton() throws IOException {
        return this.toAutomaton(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Automaton toAutomaton(boolean unicodeAware) throws IOException {
        Automaton automaton = null;
        try {
            TokenStreamToAutomaton tsta = this.preserveSep ? new EscapingTokenStreamToAutomaton('\u001f') : new TokenStreamToAutomaton();
            tsta.setPreservePositionIncrements(this.preservePositionIncrements);
            tsta.setUnicodeArcs(unicodeAware);
            automaton = tsta.toAutomaton(this.inputTokenStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(this.inputTokenStream);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(this.inputTokenStream);
        automaton = CompletionTokenStream.replaceSep(automaton, this.preserveSep, 31);
        return Operations.determinize(automaton, this.maxGraphExpansions);
    }

    private static Automaton replaceSep(Automaton a, boolean preserveSep, int sepLabel) {
        Automaton result = new Automaton();
        int numStates = a.getNumStates();
        for (int s = 0; s < numStates; ++s) {
            result.createState();
            result.setAccept(s, a.isAccept(s));
        }
        Transition t = new Transition();
        int[] topoSortStates = Operations.topoSortStates(a);
        for (int i = 0; i < topoSortStates.length; ++i) {
            int state = topoSortStates[topoSortStates.length - 1 - i];
            int count = a.initTransition(state, t);
            for (int j = 0; j < count; ++j) {
                a.getNextTransition(t);
                if (t.min == 31) {
                    assert (t.max == 31);
                    if (preserveSep) {
                        result.addTransition(state, t.dest, sepLabel);
                        continue;
                    }
                    result.addEpsilon(state, t.dest);
                    continue;
                }
                if (t.min == 30) {
                    assert (t.max == 30);
                    result.addEpsilon(state, t.dest);
                    continue;
                }
                result.addTransition(state, t.dest, t.min, t.max);
            }
        }
        result.finishState();
        return result;
    }

    public static final class BytesRefBuilderTermAttributeImpl
    extends AttributeImpl
    implements BytesRefBuilderTermAttribute,
    TermToBytesRefAttribute {
        private final BytesRefBuilder bytes = new BytesRefBuilder();
        private transient CharsRefBuilder charsRef;

        @Override
        public BytesRefBuilder builder() {
            return this.bytes;
        }

        @Override
        public BytesRef getBytesRef() {
            return this.bytes.get();
        }

        @Override
        public void clear() {
            this.bytes.clear();
        }

        @Override
        public void copyTo(AttributeImpl target) {
            BytesRefBuilderTermAttributeImpl other = (BytesRefBuilderTermAttributeImpl)target;
            other.bytes.copyBytes(this.bytes);
        }

        @Override
        public AttributeImpl clone() {
            BytesRefBuilderTermAttributeImpl other = new BytesRefBuilderTermAttributeImpl();
            this.copyTo(other);
            return other;
        }

        @Override
        public void reflectWith(AttributeReflector reflector) {
            reflector.reflect(TermToBytesRefAttribute.class, "bytes", this.getBytesRef());
        }

        @Override
        public CharSequence toUTF16() {
            if (this.charsRef == null) {
                this.charsRef = new CharsRefBuilder();
            }
            this.charsRef.copyUTF8Bytes(this.getBytesRef());
            return this.charsRef.get();
        }
    }

    public static interface BytesRefBuilderTermAttribute
    extends TermToBytesRefAttribute {
        public BytesRefBuilder builder();

        public CharSequence toUTF16();
    }

    private static final class EscapingTokenStreamToAutomaton
    extends TokenStreamToAutomaton {
        final BytesRefBuilder spare = new BytesRefBuilder();
        private char sepLabel;

        public EscapingTokenStreamToAutomaton(char sepLabel) {
            this.sepLabel = sepLabel;
        }

        @Override
        protected BytesRef changeToken(BytesRef in) {
            int upto = 0;
            for (int i = 0; i < in.length; ++i) {
                byte b = in.bytes[in.offset + i];
                if (b == (byte)this.sepLabel) {
                    this.spare.grow(upto + 2);
                    this.spare.setByteAt(upto++, (byte)this.sepLabel);
                    this.spare.setByteAt(upto++, b);
                    continue;
                }
                this.spare.grow(upto + 1);
                this.spare.setByteAt(upto++, b);
            }
            this.spare.setLength(upto);
            return this.spare.get();
        }
    }
}

