/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.suggest;

import java.util.Comparator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.suggest.fst.BytesRefSorter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRefArray;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRefIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Counter;

public final class InMemorySorter
implements BytesRefSorter {
    private final BytesRefArray buffer = new BytesRefArray(Counter.newCounter());
    private boolean closed = false;
    private final Comparator<BytesRef> comparator;

    public InMemorySorter(Comparator<BytesRef> comparator) {
        this.comparator = comparator;
    }

    @Override
    public void add(BytesRef utf8) {
        if (this.closed) {
            throw new IllegalStateException();
        }
        this.buffer.append(utf8);
    }

    @Override
    public BytesRefIterator iterator() {
        this.closed = true;
        return this.buffer.iterator(this.comparator);
    }

    @Override
    public Comparator<BytesRef> getComparator() {
        return this.comparator;
    }
}

