/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.join;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedSetDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SortedNumericSelector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.SortedSetSelector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BitSet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;

public class BlockJoinSelector {
    private BlockJoinSelector() {
    }

    public static Bits wrap(final Bits docsWithValue, final BitSet parents, final BitSet children) {
        return new Bits(){

            @Override
            public boolean get(int docID) {
                assert (parents.get(docID)) : "this selector may only be used on parent documents";
                if (docID == 0) {
                    return false;
                }
                int firstChild = parents.prevSetBit(docID - 1) + 1;
                int child = children.nextSetBit(firstChild);
                while (child < docID) {
                    if (docsWithValue.get(child)) {
                        return true;
                    }
                    child = children.nextSetBit(child + 1);
                }
                return false;
            }

            @Override
            public int length() {
                return docsWithValue.length();
            }
        };
    }

    public static SortedDocValues wrap(SortedSetDocValues sortedSet, Type selection, BitSet parents, BitSet children) {
        SortedDocValues values;
        switch (selection) {
            case MIN: {
                values = SortedSetSelector.wrap(sortedSet, SortedSetSelector.Type.MIN);
                break;
            }
            case MAX: {
                values = SortedSetSelector.wrap(sortedSet, SortedSetSelector.Type.MAX);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return BlockJoinSelector.wrap(values, selection, parents, children);
    }

    public static SortedDocValues wrap(final SortedDocValues values, final Type selection, final BitSet parents, final BitSet children) {
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                assert (parents.get(docID)) : "this selector may only be used on parent documents";
                if (docID == 0) {
                    return -1;
                }
                int firstChild = parents.prevSetBit(docID - 1) + 1;
                int ord = -1;
                int child = children.nextSetBit(firstChild);
                while (child < docID) {
                    int childOrd = values.getOrd(child);
                    switch (selection) {
                        case MIN: {
                            if (ord == -1) {
                                ord = childOrd;
                                break;
                            }
                            if (childOrd == -1) break;
                            ord = Math.min(ord, childOrd);
                            break;
                        }
                        case MAX: {
                            ord = Math.max(ord, childOrd);
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    child = children.nextSetBit(child + 1);
                }
                return ord;
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                return values.lookupOrd(ord);
            }

            @Override
            public int getValueCount() {
                return values.getValueCount();
            }
        };
    }

    public static NumericDocValues wrap(SortedNumericDocValues sortedNumerics, Type selection, BitSet parents, BitSet children) {
        NumericDocValues values;
        switch (selection) {
            case MIN: {
                values = SortedNumericSelector.wrap(sortedNumerics, SortedNumericSelector.Type.MIN, SortField.Type.LONG);
                break;
            }
            case MAX: {
                values = SortedNumericSelector.wrap(sortedNumerics, SortedNumericSelector.Type.MAX, SortField.Type.LONG);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return BlockJoinSelector.wrap(values, DocValues.docsWithValue(sortedNumerics, parents.length()), selection, parents, children);
    }

    public static NumericDocValues wrap(final NumericDocValues values, final Bits docsWithValue, final Type selection, final BitSet parents, final BitSet children) {
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                assert (parents.get(docID)) : "this selector may only be used on parent documents";
                if (docID == 0) {
                    return 0L;
                }
                int firstChild = parents.prevSetBit(docID - 1) + 1;
                long value = 0L;
                boolean hasValue = false;
                int child = children.nextSetBit(firstChild);
                while (child < docID) {
                    boolean childHasValue;
                    long childValue = values.get(child);
                    boolean bl = childHasValue = value != 0L || docsWithValue.get(child);
                    if (!hasValue) {
                        value = childValue;
                        hasValue = childHasValue;
                    } else if (childHasValue) {
                        switch (selection) {
                            case MIN: {
                                value = Math.min(value, childValue);
                                break;
                            }
                            case MAX: {
                                value = Math.max(value, childValue);
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                    }
                    child = children.nextSetBit(child + 1);
                }
                return value;
            }
        };
    }

    public static enum Type {
        MIN,
        MAX;

    }
}

