/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.highlight;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.highlight.Encoder;

public class SimpleHTMLEncoder
implements Encoder {
    @Override
    public String encodeText(String originalText) {
        return SimpleHTMLEncoder.htmlEncode(originalText);
    }

    public static final String htmlEncode(String plainText) {
        if (plainText == null || plainText.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(plainText.length());
        block8: for (int index = 0; index < plainText.length(); ++index) {
            char ch = plainText.charAt(index);
            switch (ch) {
                case '\"': {
                    result.append("&quot;");
                    continue block8;
                }
                case '&': {
                    result.append("&amp;");
                    continue block8;
                }
                case '<': {
                    result.append("&lt;");
                    continue block8;
                }
                case '>': {
                    result.append("&gt;");
                    continue block8;
                }
                case '\'': {
                    result.append("&#x27;");
                    continue block8;
                }
                case '/': {
                    result.append("&#x2F;");
                    continue block8;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }
}

