/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.grouping.function;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.queries.function.ValueSource;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.grouping.AllGroupHeadsCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.grouping.AllGroupsCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.grouping.FirstPassGroupingCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.grouping.Grouper;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.grouping.SearchGroup;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.grouping.SecondPassGroupingCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.grouping.function.FunctionAllGroupHeadsCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.grouping.function.FunctionAllGroupsCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.grouping.function.FunctionFirstPassGroupingCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.grouping.function.FunctionSecondPassGroupingCollector;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.mutable.MutableValue;

public class FunctionGrouper
extends Grouper<MutableValue> {
    private final ValueSource valueSource;
    private final Map<?, ?> context;

    public FunctionGrouper(ValueSource valueSource, Map<?, ?> context) {
        this.valueSource = valueSource;
        this.context = context;
    }

    @Override
    public FirstPassGroupingCollector<MutableValue> getFirstPassCollector(Sort sort, int count) throws IOException {
        return new FunctionFirstPassGroupingCollector(this.valueSource, this.context, sort, count);
    }

    @Override
    public AllGroupHeadsCollector<MutableValue> getGroupHeadsCollector(Sort sort) {
        return new FunctionAllGroupHeadsCollector(this.valueSource, this.context, sort);
    }

    @Override
    public AllGroupsCollector<MutableValue> getAllGroupsCollector() {
        return new FunctionAllGroupsCollector(this.valueSource, this.context);
    }

    @Override
    public SecondPassGroupingCollector<MutableValue> getSecondPassCollector(Collection<SearchGroup<MutableValue>> searchGroups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields) throws IOException {
        return new FunctionSecondPassGroupingCollector(searchGroups, groupSort, withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields, this.valueSource, this.context);
    }
}

