/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ConstantScoreScorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ConstantScoreWeight;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.TwoPhaseIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Bits;

public abstract class RandomAccessWeight
extends ConstantScoreWeight {
    protected RandomAccessWeight(Query query) {
        super(query);
    }

    protected abstract Bits getMatchingDocs(LeafReaderContext var1) throws IOException;

    @Override
    public final Scorer scorer(LeafReaderContext context) throws IOException {
        final Bits matchingDocs = this.getMatchingDocs(context);
        if (matchingDocs == null || matchingDocs instanceof Bits.MatchNoBits) {
            return null;
        }
        DocIdSetIterator approximation = DocIdSetIterator.all(context.reader().maxDoc());
        TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

            @Override
            public boolean matches() throws IOException {
                int doc = this.approximation.docID();
                return matchingDocs.get(doc);
            }

            @Override
            public float matchCost() {
                return 10.0f;
            }
        };
        return new ConstantScoreScorer((Weight)this, this.score(), twoPhase);
    }
}

