/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.RandomAccessWeight;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Bits;

public final class FieldValueQuery
extends Query {
    private final String field;

    public FieldValueQuery(String field) {
        this.field = Objects.requireNonNull(field);
    }

    public String getField() {
        return this.field;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.field.equals(((FieldValueQuery)other).field);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.field.hashCode();
    }

    @Override
    public String toString(String field) {
        return "FieldValueQuery [field=" + this.field + "]";
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new RandomAccessWeight(this){

            @Override
            protected Bits getMatchingDocs(LeafReaderContext context) throws IOException {
                return context.reader().getDocsWithField(FieldValueQuery.this.field);
            }
        };
    }
}

