/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SegmentInfo;

public class SegmentCommitInfo {
    public final SegmentInfo info;
    private int delCount;
    private long delGen;
    private long nextWriteDelGen;
    private long fieldInfosGen;
    private long nextWriteFieldInfosGen;
    private long docValuesGen;
    private long nextWriteDocValuesGen;
    private final Map<Integer, Set<String>> dvUpdatesFiles = new HashMap<Integer, Set<String>>();
    private final Set<String> fieldInfosFiles = new HashSet<String>();
    private volatile long sizeInBytes = -1L;
    private long bufferedDeletesGen;

    public SegmentCommitInfo(SegmentInfo info, int delCount, long delGen, long fieldInfosGen, long docValuesGen) {
        this.info = info;
        this.delCount = delCount;
        this.delGen = delGen;
        this.nextWriteDelGen = delGen == -1L ? 1L : delGen + 1L;
        this.fieldInfosGen = fieldInfosGen;
        this.nextWriteFieldInfosGen = fieldInfosGen == -1L ? 1L : fieldInfosGen + 1L;
        this.docValuesGen = docValuesGen;
        this.nextWriteDocValuesGen = docValuesGen == -1L ? 1L : docValuesGen + 1L;
    }

    public Map<Integer, Set<String>> getDocValuesUpdatesFiles() {
        return Collections.unmodifiableMap(this.dvUpdatesFiles);
    }

    public void setDocValuesUpdatesFiles(Map<Integer, Set<String>> dvUpdatesFiles) {
        this.dvUpdatesFiles.clear();
        for (Map.Entry<Integer, Set<String>> kv : dvUpdatesFiles.entrySet()) {
            HashSet<String> set = new HashSet<String>();
            for (String file : kv.getValue()) {
                set.add(this.info.namedForThisSegment(file));
            }
            this.dvUpdatesFiles.put(kv.getKey(), set);
        }
    }

    public Set<String> getFieldInfosFiles() {
        return Collections.unmodifiableSet(this.fieldInfosFiles);
    }

    public void setFieldInfosFiles(Set<String> fieldInfosFiles) {
        this.fieldInfosFiles.clear();
        for (String file : fieldInfosFiles) {
            this.fieldInfosFiles.add(this.info.namedForThisSegment(file));
        }
    }

    void advanceDelGen() {
        this.delGen = this.nextWriteDelGen;
        this.nextWriteDelGen = this.delGen + 1L;
        this.sizeInBytes = -1L;
    }

    void advanceNextWriteDelGen() {
        ++this.nextWriteDelGen;
    }

    long getNextWriteDelGen() {
        return this.nextWriteDelGen;
    }

    void setNextWriteDelGen(long v) {
        this.nextWriteDelGen = v;
    }

    void advanceFieldInfosGen() {
        this.fieldInfosGen = this.nextWriteFieldInfosGen;
        this.nextWriteFieldInfosGen = this.fieldInfosGen + 1L;
        this.sizeInBytes = -1L;
    }

    void advanceNextWriteFieldInfosGen() {
        ++this.nextWriteFieldInfosGen;
    }

    long getNextWriteFieldInfosGen() {
        return this.nextWriteFieldInfosGen;
    }

    void setNextWriteFieldInfosGen(long v) {
        this.nextWriteFieldInfosGen = v;
    }

    void advanceDocValuesGen() {
        this.docValuesGen = this.nextWriteDocValuesGen;
        this.nextWriteDocValuesGen = this.docValuesGen + 1L;
        this.sizeInBytes = -1L;
    }

    void advanceNextWriteDocValuesGen() {
        ++this.nextWriteDocValuesGen;
    }

    long getNextWriteDocValuesGen() {
        return this.nextWriteDocValuesGen;
    }

    void setNextWriteDocValuesGen(long v) {
        this.nextWriteDocValuesGen = v;
    }

    public long sizeInBytes() throws IOException {
        if (this.sizeInBytes == -1L) {
            long sum = 0L;
            for (String fileName : this.files()) {
                sum += this.info.dir.fileLength(fileName);
            }
            this.sizeInBytes = sum;
        }
        return this.sizeInBytes;
    }

    public Collection<String> files() throws IOException {
        HashSet<String> files = new HashSet<String>(this.info.files());
        this.info.getCodec().liveDocsFormat().files(this, files);
        for (Set<String> updatefiles : this.dvUpdatesFiles.values()) {
            files.addAll(updatefiles);
        }
        files.addAll(this.fieldInfosFiles);
        return files;
    }

    long getBufferedDeletesGen() {
        return this.bufferedDeletesGen;
    }

    void setBufferedDeletesGen(long v) {
        this.bufferedDeletesGen = v;
        this.sizeInBytes = -1L;
    }

    public boolean hasDeletions() {
        return this.delGen != -1L;
    }

    public boolean hasFieldUpdates() {
        return this.fieldInfosGen != -1L;
    }

    public long getNextFieldInfosGen() {
        return this.nextWriteFieldInfosGen;
    }

    public long getFieldInfosGen() {
        return this.fieldInfosGen;
    }

    public long getNextDocValuesGen() {
        return this.nextWriteDocValuesGen;
    }

    public long getDocValuesGen() {
        return this.docValuesGen;
    }

    public long getNextDelGen() {
        return this.nextWriteDelGen;
    }

    public long getDelGen() {
        return this.delGen;
    }

    public int getDelCount() {
        return this.delCount;
    }

    void setDelCount(int delCount) {
        if (delCount < 0 || delCount > this.info.maxDoc()) {
            throw new IllegalArgumentException("invalid delCount=" + delCount + " (maxDoc=" + this.info.maxDoc() + ")");
        }
        this.delCount = delCount;
    }

    public String toString(int pendingDelCount) {
        String s = this.info.toString(this.delCount + pendingDelCount);
        if (this.delGen != -1L) {
            s = s + ":delGen=" + this.delGen;
        }
        if (this.fieldInfosGen != -1L) {
            s = s + ":fieldInfosGen=" + this.fieldInfosGen;
        }
        if (this.docValuesGen != -1L) {
            s = s + ":dvGen=" + this.docValuesGen;
        }
        return s;
    }

    public String toString() {
        return this.toString(0);
    }

    public SegmentCommitInfo clone() {
        SegmentCommitInfo other = new SegmentCommitInfo(this.info, this.delCount, this.delGen, this.fieldInfosGen, this.docValuesGen);
        other.nextWriteDelGen = this.nextWriteDelGen;
        other.nextWriteFieldInfosGen = this.nextWriteFieldInfosGen;
        other.nextWriteDocValuesGen = this.nextWriteDocValuesGen;
        for (Map.Entry<Integer, Set<String>> e : this.dvUpdatesFiles.entrySet()) {
            other.dvUpdatesFiles.put(e.getKey(), new HashSet(e.getValue()));
        }
        other.fieldInfosFiles.addAll(this.fieldInfosFiles);
        return other;
    }
}

