/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValuesWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SegmentWriteState;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Counter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.FixedBitSet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.packed.PackedLongValues;

class NumericDocValuesWriter
extends DocValuesWriter {
    private static final long MISSING = 0L;
    private PackedLongValues.Builder pending = PackedLongValues.deltaPackedBuilder(0.0f);
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private FixedBitSet docsWithField = new FixedBitSet(64);
    private final FieldInfo fieldInfo;

    public NumericDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithFieldBytesUsed();
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, long value) {
        if ((long)docID < this.pending.size()) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        for (int i = (int)this.pending.size(); i < docID; ++i) {
            this.pending.add(0L);
        }
        this.pending.add(value);
        this.docsWithField = FixedBitSet.ensureCapacity(this.docsWithField, docID);
        this.docsWithField.set(docID);
        this.updateBytesUsed();
    }

    private long docsWithFieldBytesUsed() {
        return RamUsageEstimator.sizeOf(this.docsWithField.getBits()) + 64L;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.docsWithFieldBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    public void finish(int maxDoc) {
    }

    @Override
    public void flush(SegmentWriteState state, DocValuesConsumer dvConsumer) throws IOException {
        final int maxDoc = state.segmentInfo.maxDoc();
        final PackedLongValues values = this.pending.build();
        dvConsumer.addNumericField(this.fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new NumericIterator(maxDoc, values, NumericDocValuesWriter.this.docsWithField);
            }
        });
    }

    private static class NumericIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;
        final FixedBitSet docsWithField;
        final int size;
        final int maxDoc;
        int upto;

        NumericIterator(int maxDoc, PackedLongValues values, FixedBitSet docsWithFields) {
            this.maxDoc = maxDoc;
            this.iter = values.iterator();
            this.size = (int)values.size();
            this.docsWithField = docsWithFields;
        }

        @Override
        public boolean hasNext() {
            return this.upto < this.maxDoc;
        }

        @Override
        public Number next() {
            Long value;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.upto < this.size) {
                long v = this.iter.next();
                value = this.docsWithField.get(this.upto) ? Long.valueOf(v) : null;
            } else {
                value = null;
            }
            ++this.upto;
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

