/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.AbortingException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValuesUpdate;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocumentsWriterFlushControl;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocumentsWriterFlushQueue;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocumentsWriterPerThreadPool;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInfos;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FlushPolicy;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexWriter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SegmentInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.AlreadyClosedException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.InfoStream;

final class DocumentsWriter
implements Closeable,
Accountable {
    private final Directory directoryOrig;
    private final Directory directory;
    private volatile boolean closed;
    private final InfoStream infoStream;
    private final LiveIndexWriterConfig config;
    private final AtomicInteger numDocsInRAM = new AtomicInteger(0);
    volatile DocumentsWriterDeleteQueue deleteQueue = new DocumentsWriterDeleteQueue();
    private final DocumentsWriterFlushQueue ticketQueue = new DocumentsWriterFlushQueue();
    private volatile boolean pendingChangesInCurrentFullFlush;
    final DocumentsWriterPerThreadPool perThreadPool;
    final FlushPolicy flushPolicy;
    final DocumentsWriterFlushControl flushControl;
    private final IndexWriter writer;
    private final Queue<IndexWriter.Event> events;
    private long lastSeqNo;
    private volatile DocumentsWriterDeleteQueue currentFullFlushDelQueue = null;

    DocumentsWriter(IndexWriter writer, LiveIndexWriterConfig config, Directory directoryOrig, Directory directory) {
        this.directoryOrig = directoryOrig;
        this.directory = directory;
        this.config = config;
        this.infoStream = config.getInfoStream();
        this.perThreadPool = config.getIndexerThreadPool();
        this.flushPolicy = config.getFlushPolicy();
        this.writer = writer;
        this.events = new ConcurrentLinkedQueue<IndexWriter.Event>();
        this.flushControl = new DocumentsWriterFlushControl(this, config, writer.bufferedUpdatesStream);
    }

    synchronized long deleteQueries(Query ... queries) throws IOException {
        DocumentsWriterDeleteQueue deleteQueue = this.deleteQueue;
        long seqNo = deleteQueue.addDelete(queries);
        this.flushControl.doOnDelete();
        if (this.applyAllDeletes(deleteQueue)) {
            seqNo = -seqNo;
        }
        this.lastSeqNo = Math.max(this.lastSeqNo, seqNo);
        return seqNo;
    }

    synchronized void setLastSeqNo(long seqNo) {
        this.lastSeqNo = seqNo;
    }

    synchronized long deleteTerms(Term ... terms) throws IOException {
        DocumentsWriterDeleteQueue deleteQueue = this.deleteQueue;
        long seqNo = deleteQueue.addDelete(terms);
        this.flushControl.doOnDelete();
        if (this.applyAllDeletes(deleteQueue)) {
            seqNo = -seqNo;
        }
        this.lastSeqNo = Math.max(this.lastSeqNo, seqNo);
        return seqNo;
    }

    synchronized long updateDocValues(DocValuesUpdate ... updates) throws IOException {
        DocumentsWriterDeleteQueue deleteQueue = this.deleteQueue;
        long seqNo = deleteQueue.addDocValuesUpdates(updates);
        this.flushControl.doOnDelete();
        if (this.applyAllDeletes(deleteQueue)) {
            seqNo = -seqNo;
        }
        this.lastSeqNo = Math.max(this.lastSeqNo, seqNo);
        return seqNo;
    }

    DocumentsWriterDeleteQueue currentDeleteSession() {
        return this.deleteQueue;
    }

    private boolean applyAllDeletes(DocumentsWriterDeleteQueue deleteQueue) throws IOException {
        if (this.flushControl.getAndResetApplyAllDeletes()) {
            if (deleteQueue != null && !this.flushControl.isFullFlush()) {
                this.ticketQueue.addDeletes(deleteQueue);
            }
            this.putEvent(ApplyDeletesEvent.INSTANCE);
            return true;
        }
        return false;
    }

    int purgeBuffer(IndexWriter writer, boolean forced) throws IOException {
        if (forced) {
            return this.ticketQueue.forcePurge(writer);
        }
        return this.ticketQueue.tryPurge(writer);
    }

    int getNumDocs() {
        return this.numDocsInRAM.get();
    }

    private void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this IndexWriter is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void abort(IndexWriter writer) {
        assert (!Thread.holdsLock(writer)) : "IndexWriter lock should never be hold when aborting";
        boolean success = false;
        try {
            this.deleteQueue.clear();
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "abort");
            }
            int limit = this.perThreadPool.getActiveThreadStateCount();
            for (int i = 0; i < limit; ++i) {
                DocumentsWriterPerThreadPool.ThreadState perThread = this.perThreadPool.getThreadState(i);
                perThread.lock();
                try {
                    this.abortThreadState(perThread);
                    continue;
                }
                finally {
                    perThread.unlock();
                }
            }
            this.flushControl.abortPendingFlushes();
            this.flushControl.waitForFlush();
            success = true;
        }
        finally {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "done abort success=" + success);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized long lockAndAbortAll(IndexWriter indexWriter) {
        assert (indexWriter.holdsFullFlushLock());
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", "lockAndAbortAll");
        }
        long abortedDocCount = 0L;
        boolean success = false;
        try {
            this.deleteQueue.clear();
            int limit = this.perThreadPool.getMaxThreadStates();
            this.perThreadPool.setAbort();
            for (int i = 0; i < limit; ++i) {
                DocumentsWriterPerThreadPool.ThreadState perThread = this.perThreadPool.getThreadState(i);
                perThread.lock();
                abortedDocCount += (long)this.abortThreadState(perThread);
            }
            this.deleteQueue.clear();
            this.deleteQueue.skipSequenceNumbers(this.perThreadPool.getActiveThreadStateCount() + 1);
            this.flushControl.abortPendingFlushes();
            this.flushControl.waitForFlush();
            success = true;
            long l = abortedDocCount;
            return l;
        }
        finally {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", "finished lockAndAbortAll success=" + success);
            }
            if (!success) {
                this.unlockAllAfterAbortAll(indexWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int abortThreadState(DocumentsWriterPerThreadPool.ThreadState perThread) {
        assert (perThread.isHeldByCurrentThread());
        if (perThread.isInitialized()) {
            try {
                int abortedDocCount = perThread.dwpt.getNumDocsInRAM();
                this.subtractFlushedNumDocs(abortedDocCount);
                perThread.dwpt.abort();
                int n = abortedDocCount;
                return n;
            }
            finally {
                this.flushControl.doOnAbort(perThread);
            }
        }
        this.flushControl.doOnAbort(perThread);
        return 0;
    }

    synchronized void unlockAllAfterAbortAll(IndexWriter indexWriter) {
        assert (indexWriter.holdsFullFlushLock());
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", "unlockAll");
        }
        int limit = this.perThreadPool.getMaxThreadStates();
        this.perThreadPool.clearAbort();
        for (int i = 0; i < limit; ++i) {
            try {
                DocumentsWriterPerThreadPool.ThreadState perThread = this.perThreadPool.getThreadState(i);
                if (!perThread.isHeldByCurrentThread()) continue;
                perThread.unlock();
                continue;
            }
            catch (Throwable e) {
                if (!this.infoStream.isEnabled("DW")) continue;
                this.infoStream.message("DW", "unlockAll: could not unlock state: " + i + " msg:" + e.getMessage());
            }
        }
    }

    public long getMaxCompletedSequenceNumber() {
        long value = this.lastSeqNo;
        int limit = this.perThreadPool.getMaxThreadStates();
        for (int i = 0; i < limit; ++i) {
            DocumentsWriterPerThreadPool.ThreadState perThread = this.perThreadPool.getThreadState(i);
            value = Math.max(value, perThread.lastSeqNo);
        }
        return value;
    }

    boolean anyChanges() {
        boolean anyChanges;
        boolean bl = anyChanges = this.numDocsInRAM.get() != 0 || this.anyDeletions() || this.ticketQueue.hasTickets() || this.pendingChangesInCurrentFullFlush;
        if (this.infoStream.isEnabled("DW") && anyChanges) {
            this.infoStream.message("DW", "anyChanges? numDocsInRam=" + this.numDocsInRAM.get() + " deletes=" + this.anyDeletions() + " hasTickets:" + this.ticketQueue.hasTickets() + " pendingChangesInFullFlush: " + this.pendingChangesInCurrentFullFlush);
        }
        return anyChanges;
    }

    public int getBufferedDeleteTermsSize() {
        return this.deleteQueue.getBufferedUpdatesTermsSize();
    }

    public int getNumBufferedDeleteTerms() {
        return this.deleteQueue.numGlobalTermDeletes();
    }

    public boolean anyDeletions() {
        return this.deleteQueue.anyChanges();
    }

    @Override
    public void close() {
        this.closed = true;
        this.flushControl.setClosed();
    }

    private boolean preUpdate() throws IOException, AbortingException {
        this.ensureOpen();
        boolean hasEvents = false;
        if (this.flushControl.anyStalledThreads() || this.flushControl.numQueuedFlushes() > 0) {
            while (true) {
                DocumentsWriterPerThread flushingDWPT;
                if ((flushingDWPT = this.flushControl.nextPendingFlush()) != null) {
                    hasEvents |= this.doFlush(flushingDWPT);
                    continue;
                }
                this.flushControl.waitIfStalled();
                if (this.flushControl.numQueuedFlushes() == 0) break;
            }
        }
        return hasEvents;
    }

    private boolean postUpdate(DocumentsWriterPerThread flushingDWPT, boolean hasEvents) throws IOException, AbortingException {
        hasEvents |= this.applyAllDeletes(this.deleteQueue);
        if (flushingDWPT != null) {
            hasEvents |= this.doFlush(flushingDWPT);
        } else {
            DocumentsWriterPerThread nextPendingFlush = this.flushControl.nextPendingFlush();
            if (nextPendingFlush != null) {
                hasEvents |= this.doFlush(nextPendingFlush);
            }
        }
        return hasEvents;
    }

    private void ensureInitialized(DocumentsWriterPerThreadPool.ThreadState state) throws IOException {
        if (state.dwpt == null) {
            FieldInfos.Builder infos = new FieldInfos.Builder(this.writer.globalFieldNumberMap);
            state.dwpt = new DocumentsWriterPerThread(this.writer, this.writer.newSegmentName(), this.directoryOrig, this.directory, this.config, this.infoStream, this.deleteQueue, infos, this.writer.pendingNumDocs, this.writer.enableTestPoints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long updateDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs, Analyzer analyzer, Term delTerm) throws IOException, AbortingException {
        DocumentsWriterPerThread flushingDWPT;
        long seqNo;
        boolean hasEvents = this.preUpdate();
        DocumentsWriterPerThreadPool.ThreadState perThread = this.flushControl.obtainAndLock();
        try {
            this.ensureOpen();
            this.ensureInitialized(perThread);
            assert (perThread.isInitialized());
            DocumentsWriterPerThread dwpt = perThread.dwpt;
            int dwptNumDocs = dwpt.getNumDocsInRAM();
            try {
                seqNo = dwpt.updateDocuments(docs, analyzer, delTerm);
            }
            catch (AbortingException ae) {
                this.flushControl.doOnAbort(perThread);
                dwpt.abort();
                throw ae;
            }
            finally {
                this.numDocsInRAM.addAndGet(dwpt.getNumDocsInRAM() - dwptNumDocs);
            }
            boolean isUpdate = delTerm != null;
            flushingDWPT = this.flushControl.doAfterDocument(perThread, isUpdate);
            assert (seqNo > perThread.lastSeqNo) : "seqNo=" + seqNo + " lastSeqNo=" + perThread.lastSeqNo;
            perThread.lastSeqNo = seqNo;
        }
        finally {
            this.perThreadPool.release(perThread);
        }
        if (this.postUpdate(flushingDWPT, hasEvents)) {
            seqNo = -seqNo;
        }
        return seqNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long updateDocument(Iterable<? extends IndexableField> doc, Analyzer analyzer, Term delTerm) throws IOException, AbortingException {
        DocumentsWriterPerThread flushingDWPT;
        long seqNo;
        boolean hasEvents = this.preUpdate();
        DocumentsWriterPerThreadPool.ThreadState perThread = this.flushControl.obtainAndLock();
        try {
            this.ensureOpen();
            this.ensureInitialized(perThread);
            assert (perThread.isInitialized());
            DocumentsWriterPerThread dwpt = perThread.dwpt;
            int dwptNumDocs = dwpt.getNumDocsInRAM();
            try {
                seqNo = dwpt.updateDocument(doc, analyzer, delTerm);
            }
            catch (AbortingException ae) {
                this.flushControl.doOnAbort(perThread);
                dwpt.abort();
                throw ae;
            }
            finally {
                this.numDocsInRAM.addAndGet(dwpt.getNumDocsInRAM() - dwptNumDocs);
            }
            boolean isUpdate = delTerm != null;
            flushingDWPT = this.flushControl.doAfterDocument(perThread, isUpdate);
            assert (seqNo > perThread.lastSeqNo) : "seqNo=" + seqNo + " lastSeqNo=" + perThread.lastSeqNo;
            perThread.lastSeqNo = seqNo;
        }
        finally {
            this.perThreadPool.release(perThread);
        }
        if (this.postUpdate(flushingDWPT, hasEvents)) {
            seqNo = -seqNo;
        }
        return seqNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlush(DocumentsWriterPerThread flushingDWPT) throws IOException, AbortingException {
        double ramBufferSizeMB;
        boolean hasEvents = false;
        while (flushingDWPT != null) {
            hasEvents = true;
            boolean success = false;
            DocumentsWriterFlushQueue.SegmentFlushTicket ticket = null;
            try {
                assert (this.currentFullFlushDelQueue == null || flushingDWPT.deleteQueue == this.currentFullFlushDelQueue) : "expected: " + this.currentFullFlushDelQueue + "but was: " + flushingDWPT.deleteQueue + " " + this.flushControl.isFullFlush();
                try {
                    ticket = this.ticketQueue.addFlushTicket(flushingDWPT);
                    int flushingDocsInRam = flushingDWPT.getNumDocsInRAM();
                    boolean dwptSuccess = false;
                    try {
                        DocumentsWriterPerThread.FlushedSegment newSegment = flushingDWPT.flush();
                        this.ticketQueue.addSegment(ticket, newSegment);
                        dwptSuccess = true;
                    }
                    finally {
                        this.subtractFlushedNumDocs(flushingDocsInRam);
                        if (!flushingDWPT.pendingFilesToDelete().isEmpty()) {
                            this.putEvent(new DeleteNewFilesEvent(flushingDWPT.pendingFilesToDelete()));
                            hasEvents = true;
                        }
                        if (!dwptSuccess) {
                            this.putEvent(new FlushFailedEvent(flushingDWPT.getSegmentInfo()));
                            hasEvents = true;
                        }
                    }
                    success = true;
                }
                finally {
                    if (!success && ticket != null) {
                        this.ticketQueue.markTicketFailed(ticket);
                    }
                }
                if (this.ticketQueue.getTicketCount() >= this.perThreadPool.getActiveThreadStateCount()) {
                    this.putEvent(ForcedPurgeEvent.INSTANCE);
                    break;
                }
            }
            finally {
                this.flushControl.doAfterFlush(flushingDWPT);
            }
            flushingDWPT = this.flushControl.nextPendingFlush();
        }
        if (hasEvents) {
            this.putEvent(MergePendingEvent.INSTANCE);
        }
        if ((ramBufferSizeMB = this.config.getRAMBufferSizeMB()) != -1.0 && (double)this.flushControl.getDeleteBytesUsed() > 1048576.0 * ramBufferSizeMB / 2.0) {
            hasEvents = true;
            if (!this.applyAllDeletes(this.deleteQueue)) {
                if (this.infoStream.isEnabled("DW")) {
                    this.infoStream.message("DW", String.format(Locale.ROOT, "force apply deletes bytesUsed=%.1f MB vs ramBuffer=%.1f MB", (double)this.flushControl.getDeleteBytesUsed() / 1048576.0, ramBufferSizeMB));
                }
                this.putEvent(ApplyDeletesEvent.INSTANCE);
            }
        }
        return hasEvents;
    }

    void subtractFlushedNumDocs(int numFlushed) {
        int oldValue = this.numDocsInRAM.get();
        while (!this.numDocsInRAM.compareAndSet(oldValue, oldValue - numFlushed)) {
            oldValue = this.numDocsInRAM.get();
        }
        assert (this.numDocsInRAM.get() >= 0);
    }

    private synchronized boolean setFlushingDeleteQueue(DocumentsWriterDeleteQueue session) {
        this.currentFullFlushDelQueue = session;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long flushAllThreads() throws IOException, AbortingException {
        long seqNo;
        DocumentsWriterDeleteQueue flushingDeleteQueue;
        if (this.infoStream.isEnabled("DW")) {
            this.infoStream.message("DW", "startFullFlush");
        }
        DocumentsWriter documentsWriter = this;
        synchronized (documentsWriter) {
            this.pendingChangesInCurrentFullFlush = this.anyChanges();
            flushingDeleteQueue = this.deleteQueue;
            seqNo = this.flushControl.markForFullFlush();
            assert (this.setFlushingDeleteQueue(flushingDeleteQueue));
        }
        assert (this.currentFullFlushDelQueue != null);
        assert (this.currentFullFlushDelQueue != this.deleteQueue);
        boolean anythingFlushed = false;
        try {
            DocumentsWriterPerThread flushingDWPT;
            while ((flushingDWPT = this.flushControl.nextPendingFlush()) != null) {
                anythingFlushed |= this.doFlush(flushingDWPT);
            }
            this.flushControl.waitForFlush();
            if (!anythingFlushed && flushingDeleteQueue.anyChanges()) {
                if (this.infoStream.isEnabled("DW")) {
                    this.infoStream.message("DW", Thread.currentThread().getName() + ": flush naked frozen global deletes");
                }
                this.ticketQueue.addDeletes(flushingDeleteQueue);
            }
            this.ticketQueue.forcePurge(this.writer);
            assert (!flushingDeleteQueue.anyChanges() && !this.ticketQueue.hasTickets());
        }
        finally {
            assert (flushingDeleteQueue == this.currentFullFlushDelQueue);
        }
        if (anythingFlushed) {
            return -seqNo;
        }
        return seqNo;
    }

    void finishFullFlush(IndexWriter indexWriter, boolean success) {
        assert (indexWriter.holdsFullFlushLock());
        try {
            if (this.infoStream.isEnabled("DW")) {
                this.infoStream.message("DW", Thread.currentThread().getName() + " finishFullFlush success=" + success);
            }
            assert (this.setFlushingDeleteQueue(null));
            if (success) {
                this.flushControl.finishFullFlush();
            } else {
                this.flushControl.abortFullFlushes();
            }
        }
        finally {
            this.pendingChangesInCurrentFullFlush = false;
        }
    }

    public LiveIndexWriterConfig getIndexWriterConfig() {
        return this.config;
    }

    private void putEvent(IndexWriter.Event event) {
        this.events.add(event);
    }

    @Override
    public long ramBytesUsed() {
        return this.flushControl.ramBytesUsed();
    }

    public Queue<IndexWriter.Event> eventQueue() {
        return this.events;
    }

    static class DeleteNewFilesEvent
    implements IndexWriter.Event {
        private final Collection<String> files;

        public DeleteNewFilesEvent(Collection<String> files) {
            this.files = files;
        }

        @Override
        public void process(IndexWriter writer, boolean triggerMerge, boolean forcePurge) throws IOException {
            writer.deleteNewFiles(this.files);
        }
    }

    static class FlushFailedEvent
    implements IndexWriter.Event {
        private final SegmentInfo info;

        public FlushFailedEvent(SegmentInfo info) {
            this.info = info;
        }

        @Override
        public void process(IndexWriter writer, boolean triggerMerge, boolean forcePurge) throws IOException {
            writer.flushFailed(this.info);
        }
    }

    static final class ForcedPurgeEvent
    implements IndexWriter.Event {
        static final IndexWriter.Event INSTANCE = new ForcedPurgeEvent();
        private int instCount = 0;

        private ForcedPurgeEvent() {
            assert (this.instCount == 0);
            ++this.instCount;
        }

        @Override
        public void process(IndexWriter writer, boolean triggerMerge, boolean forcePurge) throws IOException {
            writer.purge(true);
        }
    }

    static final class MergePendingEvent
    implements IndexWriter.Event {
        static final IndexWriter.Event INSTANCE = new MergePendingEvent();
        private int instCount = 0;

        private MergePendingEvent() {
            assert (this.instCount == 0);
            ++this.instCount;
        }

        @Override
        public void process(IndexWriter writer, boolean triggerMerge, boolean forcePurge) throws IOException {
            writer.doAfterSegmentFlushed(triggerMerge, forcePurge);
        }
    }

    static final class ApplyDeletesEvent
    implements IndexWriter.Event {
        static final IndexWriter.Event INSTANCE = new ApplyDeletesEvent();
        private int instCount = 0;

        private ApplyDeletesEvent() {
            assert (this.instCount == 0);
            ++this.instCount;
        }

        @Override
        public void process(IndexWriter writer, boolean triggerMerge, boolean forcePurge) throws IOException {
            writer.applyDeletesAndPurge(true);
        }
    }
}

