/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.codecs.compressing;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.MergeState;

class MatchingReaders {
    final boolean[] matchingReaders;
    final int count;

    MatchingReaders(MergeState mergeState) {
        int numReaders = mergeState.maxDocs.length;
        int matchedCount = 0;
        this.matchingReaders = new boolean[numReaders];
        block0: for (int i = 0; i < numReaders; ++i) {
            for (FieldInfo fi : mergeState.fieldInfos[i]) {
                FieldInfo other = mergeState.mergeFieldInfos.fieldInfo(fi.number);
                if (other != null && other.name.equals(fi.name)) continue;
                continue block0;
            }
            this.matchingReaders[i] = true;
            ++matchedCount;
        }
        this.count = matchedCount;
        if (mergeState.infoStream.isEnabled("SM")) {
            mergeState.infoStream.message("SM", "merge store matchedCount=" + this.count + " vs " + numReaders);
            if (this.count != numReaders) {
                mergeState.infoStream.message("SM", "" + (numReaders - this.count) + " non-bulk merges");
            }
        }
    }
}

