/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.fa;

import java.io.IOException;
import java.io.Reader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.CharArraySet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.StopFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.ar.ArabicNormalizationFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.core.DecimalDigitFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.fa.PersianCharFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.fa.PersianNormalizationFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Version;

public final class PersianAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    public static final String STOPWORDS_COMMENT = "#";

    public static CharArraySet getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public PersianAnalyzer() {
        this(DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public PersianAnalyzer(CharArraySet stopwords) {
        super(stopwords);
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source = new StandardTokenizer();
        TokenFilter result = new LowerCaseFilter(source);
        if (this.getVersion().onOrAfter(Version.LUCENE_5_4_0)) {
            result = new DecimalDigitFilter(result);
        }
        result = new ArabicNormalizationFilter(result);
        result = new PersianNormalizationFilter(result);
        return new Analyzer.TokenStreamComponents(source, new StopFilter(result, this.stopwords));
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        TokenFilter result = new StandardFilter(in);
        result = new LowerCaseFilter(result);
        result = new DecimalDigitFilter(result);
        result = new ArabicNormalizationFilter(result);
        result = new PersianNormalizationFilter(result);
        return result;
    }

    @Override
    protected Reader initReader(String fieldName, Reader reader) {
        return new PersianCharFilter(reader);
    }

    private static class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = PersianAnalyzer.loadStopwordSet(false, PersianAnalyzer.class, PersianAnalyzer.DEFAULT_STOPWORD_FILE, PersianAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

