/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.RollingBuffer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.automaton.Automaton;

public class TokenStreamToAutomaton {
    private boolean preservePositionIncrements = true;
    private boolean unicodeArcs;
    public static final int POS_SEP = 31;
    public static final int HOLE = 30;

    public void setPreservePositionIncrements(boolean enablePositionIncrements) {
        this.preservePositionIncrements = enablePositionIncrements;
    }

    public void setUnicodeArcs(boolean unicodeArcs) {
        this.unicodeArcs = unicodeArcs;
    }

    protected BytesRef changeToken(BytesRef in) {
        return in;
    }

    public Automaton toAutomaton(TokenStream in) throws IOException {
        Automaton.Builder builder = new Automaton.Builder();
        builder.createState();
        TermToBytesRefAttribute termBytesAtt = in.addAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncAtt = in.addAttribute(PositionIncrementAttribute.class);
        PositionLengthAttribute posLengthAtt = in.addAttribute(PositionLengthAttribute.class);
        OffsetAttribute offsetAtt = in.addAttribute(OffsetAttribute.class);
        in.reset();
        Positions positions = new Positions();
        int pos = -1;
        int freedPos = 0;
        Position posData = null;
        int maxOffset = 0;
        while (in.incrementToken()) {
            int termLen;
            int posInc = posIncAtt.getPositionIncrement();
            if (!this.preservePositionIncrements && posInc > 1) {
                posInc = 1;
            }
            assert (pos > -1 || posInc > 0);
            if (posInc > 0) {
                posData = (Position)positions.get(pos += posInc);
                assert (posData.leaving == -1);
                if (posData.arriving == -1) {
                    if (pos == 0) {
                        posData.leaving = 0;
                    } else {
                        posData.leaving = builder.createState();
                        TokenStreamToAutomaton.addHoles(builder, positions, pos);
                    }
                } else {
                    posData.leaving = builder.createState();
                    builder.addTransition(posData.arriving, posData.leaving, 31);
                    if (posInc > 1) {
                        TokenStreamToAutomaton.addHoles(builder, positions, pos);
                    }
                }
                while (freedPos <= pos) {
                    Position freePosData = (Position)positions.get(freedPos);
                    if (freePosData.arriving == -1 || freePosData.leaving == -1) break;
                    positions.freeBefore(freedPos);
                    ++freedPos;
                }
            }
            int endPos = pos + posLengthAtt.getPositionLength();
            BytesRef termUTF8 = this.changeToken(termBytesAtt.getBytesRef());
            int[] termUnicode = null;
            Position endPosData = (Position)positions.get(endPos);
            if (endPosData.arriving == -1) {
                endPosData.arriving = builder.createState();
            }
            if (this.unicodeArcs) {
                int cp;
                String utf16 = termUTF8.utf8ToString();
                termUnicode = new int[utf16.codePointCount(0, utf16.length())];
                termLen = termUnicode.length;
                int j = 0;
                for (int i = 0; i < utf16.length(); i += Character.charCount(cp)) {
                    termUnicode[j++] = cp = utf16.codePointAt(i);
                }
            } else {
                termLen = termUTF8.length;
            }
            int state = posData.leaving;
            for (int byteIDX = 0; byteIDX < termLen; ++byteIDX) {
                int nextState = byteIDX == termLen - 1 ? endPosData.arriving : builder.createState();
                int c = this.unicodeArcs ? termUnicode[byteIDX] : termUTF8.bytes[termUTF8.offset + byteIDX] & 0xFF;
                builder.addTransition(state, nextState, c);
                state = nextState;
            }
            maxOffset = Math.max(maxOffset, offsetAtt.endOffset());
        }
        in.end();
        int endState = -1;
        if (offsetAtt.endOffset() > maxOffset) {
            endState = builder.createState();
            builder.setAccept(endState, true);
        }
        ++pos;
        while (pos <= positions.getMaxPos()) {
            posData = (Position)positions.get(pos);
            if (posData.arriving != -1) {
                if (endState != -1) {
                    builder.addTransition(posData.arriving, endState, 31);
                } else {
                    builder.setAccept(posData.arriving, true);
                }
            }
            ++pos;
        }
        return builder.finish();
    }

    private static void addHoles(Automaton.Builder builder, RollingBuffer<Position> positions, int pos) {
        Position posData = positions.get(pos);
        Position prevPosData = positions.get(pos - 1);
        while (posData.arriving == -1 || prevPosData.leaving == -1) {
            if (posData.arriving == -1) {
                posData.arriving = builder.createState();
                builder.addTransition(posData.arriving, posData.leaving, 31);
            }
            if (prevPosData.leaving == -1) {
                prevPosData.leaving = pos == 1 ? 0 : builder.createState();
                if (prevPosData.arriving != -1) {
                    builder.addTransition(prevPosData.arriving, prevPosData.leaving, 31);
                }
            }
            builder.addTransition(prevPosData.leaving, posData.arriving, 30);
            if (--pos <= 0) break;
            posData = prevPosData;
            prevPosData = positions.get(pos - 1);
        }
    }

    private static class Positions
    extends RollingBuffer<Position> {
        private Positions() {
        }

        @Override
        protected Position newInstance() {
            return new Position();
        }
    }

    private static class Position
    implements RollingBuffer.Resettable {
        int arriving = -1;
        int leaving = -1;

        private Position() {
        }

        @Override
        public void reset() {
            this.arriving = -1;
            this.leaving = -1;
        }
    }
}

