/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple;

import java.util.NoSuchElementException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.AbstractOptionSpec;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.AlternativeLongOptionSpec;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.NoArgumentOptionSpec;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.OptionParser;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.OptionalArgumentOptionSpec;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.ParserRules;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.joptsimple.RequiredArgumentOptionSpec;

class OptionSpecTokenizer {
    private static final char POSIXLY_CORRECT_MARKER = '+';
    private static final char HELP_MARKER = '*';
    private String specification;
    private int index;

    OptionSpecTokenizer(String specification) {
        if (specification == null) {
            throw new NullPointerException("null option specification");
        }
        this.specification = specification;
    }

    boolean hasMore() {
        return this.index < this.specification.length();
    }

    AbstractOptionSpec<?> next() {
        NoArgumentOptionSpec spec;
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        String optionCandidate = String.valueOf(this.specification.charAt(this.index));
        ++this.index;
        if ("W".equals(optionCandidate) && (spec = this.handleReservedForExtensionsToken()) != null) {
            return spec;
        }
        ParserRules.ensureLegalOption(optionCandidate);
        if (this.hasMore()) {
            boolean forHelp = false;
            if (this.specification.charAt(this.index) == '*') {
                forHelp = true;
                ++this.index;
            }
            AbstractOptionSpec abstractOptionSpec = spec = this.hasMore() && this.specification.charAt(this.index) == ':' ? this.handleArgumentAcceptingOption(optionCandidate) : new NoArgumentOptionSpec(optionCandidate);
            if (forHelp) {
                spec.forHelp();
            }
        } else {
            spec = new NoArgumentOptionSpec(optionCandidate);
        }
        return spec;
    }

    void configure(OptionParser parser) {
        this.adjustForPosixlyCorrect(parser);
        while (this.hasMore()) {
            parser.recognize(this.next());
        }
    }

    private void adjustForPosixlyCorrect(OptionParser parser) {
        if ('+' == this.specification.charAt(0)) {
            parser.posixlyCorrect(true);
            this.specification = this.specification.substring(1);
        }
    }

    private AbstractOptionSpec<?> handleReservedForExtensionsToken() {
        if (!this.hasMore()) {
            return new NoArgumentOptionSpec("W");
        }
        if (this.specification.charAt(this.index) == ';') {
            ++this.index;
            return new AlternativeLongOptionSpec();
        }
        return null;
    }

    private AbstractOptionSpec<?> handleArgumentAcceptingOption(String candidate) {
        ++this.index;
        if (this.hasMore() && this.specification.charAt(this.index) == ':') {
            ++this.index;
            return new OptionalArgumentOptionSpec(candidate);
        }
        return new RequiredArgumentOptionSpec(candidate);
    }
}

