/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc;

import java.util.Arrays;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.CharCollection;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.CharLookupContainer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.cursors.CharCursor;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.predicates.CharPredicate;

abstract class AbstractCharCollection
implements CharCollection {
    AbstractCharCollection() {
    }

    @Override
    public int removeAll(final CharLookupContainer c) {
        return this.removeAll(new CharPredicate(){

            @Override
            public boolean apply(char k) {
                return c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final CharLookupContainer c) {
        return this.removeAll(new CharPredicate(){

            @Override
            public boolean apply(char k) {
                return !c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final CharPredicate predicate) {
        return this.removeAll(new CharPredicate(){

            @Override
            public boolean apply(char value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public char[] toArray() {
        char[] array = new char[this.size()];
        int i = 0;
        for (CharCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

