/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.Iterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.PostingsEnum;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.search.lookup.IndexFieldTerm;
import org.elasticsearch.search.lookup.TermPosition;

public class PositionIterator
implements Iterator<TermPosition> {
    private boolean resetted = false;
    protected IndexFieldTerm indexFieldTerm;
    protected int freq = -1;
    private int currentPos;
    protected final TermPosition termPosition = new TermPosition();
    private PostingsEnum postings;

    public PositionIterator(IndexFieldTerm indexFieldTerm) {
        this.indexFieldTerm = indexFieldTerm;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove anything from TermPosition iterator.");
    }

    @Override
    public boolean hasNext() {
        return this.currentPos < this.freq;
    }

    @Override
    public TermPosition next() {
        try {
            this.termPosition.position = this.postings.nextPosition();
            this.termPosition.startOffset = this.postings.startOffset();
            this.termPosition.endOffset = this.postings.endOffset();
            this.termPosition.payload = this.postings.getPayload();
        }
        catch (IOException ex) {
            throw new ElasticsearchException("can not advance iterator", (Throwable)ex, new Object[0]);
        }
        ++this.currentPos;
        return this.termPosition;
    }

    public void nextDoc() throws IOException {
        this.resetted = false;
        this.currentPos = 0;
        this.freq = this.indexFieldTerm.tf();
        this.postings = this.indexFieldTerm.postings;
    }

    public Iterator<TermPosition> reset() {
        if (this.resetted) {
            throw new ElasticsearchException("Cannot iterate twice! If you want to iterate more that once, add _CACHE explicitly.", new Object[0]);
        }
        this.resetted = true;
        return this;
    }
}

