/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.support.ToXContentToBytes;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BaseAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class PipelineAggregationBuilder
extends ToXContentToBytes
implements NamedWriteable,
BaseAggregationBuilder {
    protected final String name;
    protected final String[] bucketsPaths;

    protected PipelineAggregationBuilder(String name, String[] bucketsPaths) {
        if (name == null) {
            throw new IllegalArgumentException("[name] must not be null: [" + name + "]");
        }
        if (bucketsPaths == null) {
            throw new IllegalArgumentException("[bucketsPaths] must not be null: [" + name + "]");
        }
        this.name = name;
        this.bucketsPaths = bucketsPaths;
    }

    public String getName() {
        return this.name;
    }

    public final String[] getBucketsPaths() {
        return this.bucketsPaths;
    }

    protected abstract void validate(AggregatorFactory<?> var1, AggregatorFactory<?>[] var2, List<PipelineAggregationBuilder> var3);

    protected abstract PipelineAggregator create() throws IOException;

    @Override
    public abstract PipelineAggregationBuilder setMetaData(Map<String, Object> var1);

    @Override
    public PipelineAggregationBuilder subAggregations(AggregatorFactories.Builder subFactories) {
        throw new IllegalArgumentException("Aggregation [" + this.name + "] cannot define sub-aggregations");
    }
}

