/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;

public class PreBuiltCacheFactory {
    private PreBuiltCacheFactory() {
    }

    static <T> PreBuiltCache<T> getCache(CachingStrategy cachingStrategy) {
        switch (cachingStrategy) {
            case ONE: {
                return new PreBuiltCacheStrategyOne();
            }
            case LUCENE: {
                return new PreBuiltCacheStrategyLucene();
            }
            case ELASTICSEARCH: {
                return new PreBuiltCacheStrategyElasticsearch();
            }
        }
        throw new ElasticsearchException("No action configured for caching strategy[" + (Object)((Object)cachingStrategy) + "]", new Object[0]);
    }

    private static class PreBuiltCacheStrategyLucene<T>
    implements PreBuiltCache<T> {
        private Map<org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Version, T> mapModel = new HashMap<org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Version, T>(2);

        private PreBuiltCacheStrategyLucene() {
        }

        @Override
        public T get(Version version) {
            return this.mapModel.get(version.luceneVersion);
        }

        @Override
        public void put(Version version, T model) {
            this.mapModel.put(version.luceneVersion, model);
        }
    }

    private static class PreBuiltCacheStrategyElasticsearch<T>
    implements PreBuiltCache<T> {
        Map<Version, T> mapModel = new HashMap<Version, T>(2);

        private PreBuiltCacheStrategyElasticsearch() {
        }

        @Override
        public T get(Version version) {
            return this.mapModel.get(version);
        }

        @Override
        public void put(Version version, T model) {
            this.mapModel.put(version, model);
        }
    }

    private static class PreBuiltCacheStrategyOne<T>
    implements PreBuiltCache<T> {
        private T model = null;

        private PreBuiltCacheStrategyOne() {
        }

        @Override
        public T get(Version version) {
            return this.model;
        }

        @Override
        public void put(Version version, T model) {
            this.model = model;
        }
    }

    public static interface PreBuiltCache<T> {
        public T get(Version var1);

        public void put(Version var1, T var2);
    }

    public static enum CachingStrategy {
        ONE,
        LUCENE,
        ELASTICSEARCH;

    }
}

