/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.geo.Rectangle;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.ConstantScoreQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.mapper.BaseGeoPointFieldMapper;
import org.elasticsearch.index.query.QueryShardContext;

@Deprecated
public class LegacyIndexedGeoBoundingBoxQuery {
    public static Query create(Rectangle bbox, BaseGeoPointFieldMapper.LegacyGeoPointFieldType fieldType, QueryShardContext context) {
        return LegacyIndexedGeoBoundingBoxQuery.create(bbox.minLat, bbox.minLon, bbox.maxLat, bbox.maxLon, fieldType, context);
    }

    public static Query create(GeoPoint topLeft, GeoPoint bottomRight, BaseGeoPointFieldMapper.LegacyGeoPointFieldType fieldType, QueryShardContext context) {
        return LegacyIndexedGeoBoundingBoxQuery.create(bottomRight.getLat(), topLeft.getLon(), topLeft.getLat(), bottomRight.getLon(), fieldType, context);
    }

    private static Query create(double minLat, double minLon, double maxLat, double maxLon, BaseGeoPointFieldMapper.LegacyGeoPointFieldType fieldType, QueryShardContext context) {
        if (!fieldType.isLatLonEnabled()) {
            throw new IllegalArgumentException("lat/lon is not enabled (indexed) for field [" + fieldType.name() + "], can't use indexed filter on it");
        }
        if (minLon > maxLon) {
            return LegacyIndexedGeoBoundingBoxQuery.westGeoBoundingBoxFilter(minLat, minLon, maxLat, maxLon, fieldType, context);
        }
        return LegacyIndexedGeoBoundingBoxQuery.eastGeoBoundingBoxFilter(minLat, minLon, maxLat, maxLon, fieldType, context);
    }

    private static Query westGeoBoundingBoxFilter(double minLat, double minLon, double maxLat, double maxLon, BaseGeoPointFieldMapper.LegacyGeoPointFieldType fieldType, QueryShardContext context) {
        BooleanQuery.Builder filter = new BooleanQuery.Builder();
        filter.setMinimumNumberShouldMatch(1);
        filter.add(fieldType.lonFieldType().rangeQuery(null, maxLon, true, true, context), BooleanClause.Occur.SHOULD);
        filter.add(fieldType.lonFieldType().rangeQuery(minLon, null, true, true, context), BooleanClause.Occur.SHOULD);
        filter.add(fieldType.latFieldType().rangeQuery(minLat, maxLat, true, true, context), BooleanClause.Occur.MUST);
        return new ConstantScoreQuery(filter.build());
    }

    private static Query eastGeoBoundingBoxFilter(double minLat, double minLon, double maxLat, double maxLon, BaseGeoPointFieldMapper.LegacyGeoPointFieldType fieldType, QueryShardContext context) {
        BooleanQuery.Builder filter = new BooleanQuery.Builder();
        filter.add(fieldType.lonFieldType().rangeQuery(minLon, maxLon, true, true, context), BooleanClause.Occur.MUST);
        filter.add(fieldType.latFieldType().rangeQuery(minLat, maxLat, true, true, context), BooleanClause.Occur.MUST);
        return new ConstantScoreQuery(filter.build());
    }
}

