/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.MultiFields;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.LegacyNumericUtils;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.joda.time.DateTimeZone;
import org.elasticsearch.Version;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.network.Cidrs;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.LegacyIpIndexFieldData;
import org.elasticsearch.index.mapper.LegacyLongFieldMapper;
import org.elasticsearch.index.mapper.LegacyNumberFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.DocValueFormat;

public class LegacyIpFieldMapper
extends LegacyNumberFieldMapper {
    public static final String CONTENT_TYPE = "ip";
    public static final long MAX_IP = 0x100000000L;
    private static final Pattern pattern = Pattern.compile("\\.");

    public static String longToIp(long longIp) {
        int octet3 = (int)((longIp >> 24) % 256L);
        int octet2 = (int)((longIp >> 16) % 256L);
        int octet1 = (int)((longIp >> 8) % 256L);
        int octet0 = (int)(longIp % 256L);
        return octet3 + "." + octet2 + "." + octet1 + "." + octet0;
    }

    public static long ipToLong(String ip) {
        try {
            if (!InetAddresses.isInetAddress(ip)) {
                throw new IllegalArgumentException("failed to parse ip [" + ip + "], not a valid ip address");
            }
            String[] octets = pattern.split(ip);
            if (octets.length != 4) {
                throw new IllegalArgumentException("ip [" + ip + "] is an IPv6 address, but this ip field is for an index created before 5.0. Reindex into a new index to get IPv6 support.");
            }
            return (Long.parseLong(octets[0]) << 24) + (long)(Integer.parseInt(octets[1]) << 16) + (long)(Integer.parseInt(octets[2]) << 8) + (long)Integer.parseInt(octets[3]);
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            throw new IllegalArgumentException("failed to parse ip [" + ip + "]", e);
        }
    }

    protected LegacyIpFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Boolean includeInAll, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, ignoreMalformed, coerce, includeInAll, indexSettings, multiFields, copyTo);
    }

    private static long parseValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof BytesRef) {
            return LegacyIpFieldMapper.ipToLong(((BytesRef)value).utf8ToString());
        }
        return LegacyIpFieldMapper.ipToLong(value.toString());
    }

    @Override
    protected void innerParseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        String ipAsString;
        if (context.externalValueSet()) {
            ipAsString = (String)context.externalValue();
            if (ipAsString == null) {
                ipAsString = this.fieldType().nullValueAsString();
            }
        } else {
            ipAsString = context.parser().currentToken() == XContentParser.Token.VALUE_NULL ? this.fieldType().nullValueAsString() : context.parser().text();
        }
        if (ipAsString == null) {
            return;
        }
        if (context.includeInAll(this.includeInAll, this)) {
            context.allEntries().addText(this.fieldType().name(), ipAsString, this.fieldType().boost());
        }
        long value = LegacyIpFieldMapper.ipToLong(ipAsString);
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            LegacyLongFieldMapper.CustomLongNumericField field = new LegacyLongFieldMapper.CustomLongNumericField(value, this.fieldType());
            if (this.fieldType.boost() != 1.0f && Version.indexCreated(context.indexSettings()).before(Version.V_5_0_0_alpha1)) {
                field.setBoost(this.fieldType().boost());
            }
            fields.add(field);
        }
        if (this.fieldType().hasDocValues()) {
            this.addDocValue(context, fields, value);
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.fieldType().numericPrecisionStep() != 16) {
            builder.field("precision_step", this.fieldType().numericPrecisionStep());
        }
        if (includeDefaults || this.fieldType().nullValueAsString() != null) {
            builder.field("null_value", this.fieldType().nullValueAsString());
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
    }

    public static final class IpFieldType
    extends LegacyLongFieldMapper.LongFieldType {
        public IpFieldType() {
        }

        protected IpFieldType(IpFieldType ref) {
            super(ref);
        }

        @Override
        public LegacyNumberFieldMapper.NumberFieldType clone() {
            return new IpFieldType(this);
        }

        @Override
        public String typeName() {
            return LegacyIpFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Object valueForDisplay(Object value) {
            Long val = (Long)value;
            if (val == null) {
                return null;
            }
            return LegacyIpFieldMapper.longToIp(val);
        }

        @Override
        public BytesRef indexedValueForSearch(Object value) {
            BytesRefBuilder bytesRef = new BytesRefBuilder();
            LegacyNumericUtils.longToPrefixCoded(LegacyIpFieldMapper.parseValue(value), 0, bytesRef);
            return bytesRef.get();
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            String term;
            long[] fromTo;
            if (value != null && (fromTo = (term = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString()).contains("/") ? Cidrs.cidrMaskToMinMax(term) : Cidrs.cidrMaskToMinMax(term + "/32")) != null) {
                return this.rangeQuery(fromTo[0] == 0L ? null : Long.valueOf(fromTo[0]), fromTo[1] == 0x100000000L ? null : Long.valueOf(fromTo[1]), true, false, context);
            }
            return super.termQuery(value, context);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, QueryShardContext context) {
            return LegacyNumericRangeQuery.newLongRange(this.name(), this.numericPrecisionStep(), lowerTerm == null ? null : Long.valueOf(LegacyIpFieldMapper.parseValue(lowerTerm)), upperTerm == null ? null : Long.valueOf(LegacyIpFieldMapper.parseValue(upperTerm)), includeLower, includeUpper);
        }

        @Override
        public FieldStats stats(IndexReader reader) throws IOException {
            int maxDoc = reader.maxDoc();
            FieldInfo fi = MultiFields.getMergedFieldInfos(reader).fieldInfo(this.name());
            if (fi == null) {
                return null;
            }
            Terms terms = MultiFields.getTerms(reader, this.name());
            if (terms == null) {
                return new FieldStats.Ip(maxDoc, 0L, -1L, -1L, this.isSearchable(), this.isAggregatable());
            }
            long minValue = LegacyNumericUtils.getMinLong(terms);
            long maxValue = LegacyNumericUtils.getMaxLong(terms);
            return new FieldStats.Ip(maxDoc, terms.getDocCount(), terms.getSumDocFreq(), terms.getSumTotalTermFreq(), this.isSearchable(), this.isAggregatable(), InetAddress.getByName(LegacyIpFieldMapper.longToIp(minValue)), InetAddress.getByName(LegacyIpFieldMapper.longToIp(maxValue)));
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            this.failIfNoDocValues();
            return new IndexFieldData.Builder(){

                @Override
                public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
                    return new LegacyIpIndexFieldData(indexSettings.getIndex(), this.name());
                }
            };
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, DateTimeZone timeZone) {
            if (format != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom formats");
            }
            if (timeZone != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support custom time zones");
            }
            return DocValueFormat.IP;
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                if (propNode == null) {
                    throw new MapperParsingException("Property [null_value] cannot be null.");
                }
                builder.nullValue(propNode.toString());
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends LegacyNumberFieldMapper.Builder<Builder, LegacyIpFieldMapper> {
        protected String nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, 16);
            this.builder = this;
        }

        @Override
        public LegacyIpFieldMapper build(Mapper.BuilderContext context) {
            if (context.indexCreatedVersion().onOrAfter(Version.V_5_0_0_alpha2)) {
                throw new IllegalStateException("Cannot use legacy numeric types after 5.0");
            }
            this.setupFieldType(context);
            return new LegacyIpFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), this.includeInAll, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }

        @Override
        protected int maxPrecisionStep() {
            return 64;
        }
    }

    public static class Defaults
    extends LegacyNumberFieldMapper.Defaults {
        public static final String NULL_VALUE = null;
        public static final MappedFieldType FIELD_TYPE = new IpFieldType();

        static {
            FIELD_TYPE.freeze();
        }
    }
}

