/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty3;

import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.channel.Channel;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.channel.ChannelFuture;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.channel.ChannelFutureListener;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.http.Cookie;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.http.CookieDecoder;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.http.CookieEncoder;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.http.HttpMethod;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.http.HttpRequest;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.http.HttpResponse;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.handler.codec.http.HttpVersion;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.http.netty3.Netty3HttpRequest;
import org.elasticsearch.http.netty3.Netty3HttpServerTransport;
import org.elasticsearch.http.netty3.cors.Netty3CorsHandler;
import org.elasticsearch.http.netty3.pipelining.OrderedDownstreamChannelEvent;
import org.elasticsearch.http.netty3.pipelining.OrderedUpstreamMessageEvent;
import org.elasticsearch.rest.AbstractRestChannel;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.netty3.Netty3Utils;

public final class Netty3HttpChannel
extends AbstractRestChannel {
    private final Netty3HttpServerTransport transport;
    private final Channel channel;
    private final HttpRequest nettyRequest;
    private final OrderedUpstreamMessageEvent orderedUpstreamMessageEvent;
    private final ThreadContext threadContext;
    private static final HttpResponseStatus TOO_MANY_REQUESTS = new HttpResponseStatus(429, "Too Many Requests");
    static Map<RestStatus, HttpResponseStatus> MAP;

    public Netty3HttpChannel(Netty3HttpServerTransport transport, Netty3HttpRequest request, @Nullable OrderedUpstreamMessageEvent orderedUpstreamMessageEvent, boolean detailedErrorsEnabled, ThreadContext threadContext) {
        super(request, detailedErrorsEnabled);
        this.transport = transport;
        this.channel = request.getChannel();
        this.nettyRequest = request.request();
        this.orderedUpstreamMessageEvent = orderedUpstreamMessageEvent;
        this.threadContext = threadContext;
    }

    @Override
    public BytesStreamOutput newBytesOutput() {
        return new ReleasableBytesStreamOutput(this.transport.bigArrays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(RestResponse response) {
        HttpResponse resp = this.newResponse();
        resp.setStatus(Netty3HttpChannel.getStatus(response.status()));
        Netty3CorsHandler.setCorsResponseHeaders(this.nettyRequest, resp, this.transport.getCorsConfig());
        String opaque = this.nettyRequest.headers().get("X-Opaque-Id");
        if (opaque != null) {
            this.setHeaderField(resp, "X-Opaque-Id", opaque);
        }
        this.addCustomHeaders(resp, response.getHeaders());
        this.addCustomHeaders(resp, this.threadContext.getResponseHeaders());
        BytesReference content = response.content();
        boolean addedReleaseListener = false;
        try {
            ChannelFuture future;
            ChannelBuffer buffer = Netty3Utils.toChannelBuffer(content);
            if (HttpMethod.HEAD.equals(this.nettyRequest.getMethod())) {
                resp.setContent(ChannelBuffers.EMPTY_BUFFER);
            } else {
                resp.setContent(buffer);
            }
            this.setHeaderField(resp, "Content-Type", response.contentType(), false);
            this.setHeaderField(resp, "Content-Length", String.valueOf(buffer.readableBytes()), false);
            this.addCookies(resp);
            if (this.orderedUpstreamMessageEvent != null) {
                OrderedDownstreamChannelEvent downstreamChannelEvent = new OrderedDownstreamChannelEvent(this.orderedUpstreamMessageEvent, 0, true, resp);
                future = downstreamChannelEvent.getFuture();
                this.channel.getPipeline().sendDownstream(downstreamChannelEvent);
            } else {
                future = this.channel.write(resp);
            }
            if (content instanceof Releasable) {
                future.addListener(x -> ((Releasable)((Object)content)).close());
                addedReleaseListener = true;
            }
            if (this.isCloseConnection()) {
                future.addListener(ChannelFutureListener.CLOSE);
            }
        }
        finally {
            if (!addedReleaseListener && content instanceof Releasable) {
                ((Releasable)((Object)content)).close();
            }
        }
    }

    private void setHeaderField(HttpResponse resp, String headerField, String value) {
        this.setHeaderField(resp, headerField, value, true);
    }

    private void setHeaderField(HttpResponse resp, String headerField, String value, boolean override) {
        if (override || !resp.headers().contains(headerField)) {
            resp.headers().add(headerField, value);
        }
    }

    private void addCookies(HttpResponse resp) {
        CookieDecoder cookieDecoder;
        Set<Cookie> cookies;
        String cookieString;
        if (this.transport.resetCookies && (cookieString = this.nettyRequest.headers().get("Cookie")) != null && !(cookies = (cookieDecoder = new CookieDecoder()).decode(cookieString)).isEmpty()) {
            CookieEncoder cookieEncoder = new CookieEncoder(true);
            for (Cookie cookie : cookies) {
                cookieEncoder.addCookie(cookie);
            }
            this.setHeaderField(resp, "Set-Cookie", cookieEncoder.encode());
        }
    }

    private void addCustomHeaders(HttpResponse resp, Map<String, List<String>> customHeaders) {
        if (customHeaders != null) {
            for (Map.Entry<String, List<String>> headerEntry : customHeaders.entrySet()) {
                for (String headerValue : headerEntry.getValue()) {
                    this.setHeaderField(resp, headerEntry.getKey(), headerValue);
                }
            }
        }
    }

    private boolean isHttp10() {
        return this.nettyRequest.getProtocolVersion().equals(HttpVersion.HTTP_1_0);
    }

    private boolean isCloseConnection() {
        boolean http10 = this.isHttp10();
        return "close".equalsIgnoreCase(this.nettyRequest.headers().get("Connection")) || http10 && !"keep-alive".equalsIgnoreCase(this.nettyRequest.headers().get("Connection"));
    }

    private HttpResponse newResponse() {
        DefaultHttpResponse resp;
        boolean http10 = this.isHttp10();
        boolean close = this.isCloseConnection();
        HttpResponseStatus status = HttpResponseStatus.OK;
        if (http10) {
            resp = new DefaultHttpResponse(HttpVersion.HTTP_1_0, status);
            if (!close) {
                resp.headers().add("Connection", "Keep-Alive");
            }
        } else {
            resp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        }
        return resp;
    }

    private static HttpResponseStatus getStatus(RestStatus status) {
        return MAP.getOrDefault((Object)status, HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    static {
        EnumMap<RestStatus, HttpResponseStatus> map = new EnumMap<RestStatus, HttpResponseStatus>(RestStatus.class);
        map.put(RestStatus.CONTINUE, HttpResponseStatus.CONTINUE);
        map.put(RestStatus.SWITCHING_PROTOCOLS, HttpResponseStatus.SWITCHING_PROTOCOLS);
        map.put(RestStatus.OK, HttpResponseStatus.OK);
        map.put(RestStatus.CREATED, HttpResponseStatus.CREATED);
        map.put(RestStatus.ACCEPTED, HttpResponseStatus.ACCEPTED);
        map.put(RestStatus.NON_AUTHORITATIVE_INFORMATION, HttpResponseStatus.NON_AUTHORITATIVE_INFORMATION);
        map.put(RestStatus.NO_CONTENT, HttpResponseStatus.NO_CONTENT);
        map.put(RestStatus.RESET_CONTENT, HttpResponseStatus.RESET_CONTENT);
        map.put(RestStatus.PARTIAL_CONTENT, HttpResponseStatus.PARTIAL_CONTENT);
        map.put(RestStatus.MULTI_STATUS, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        map.put(RestStatus.MULTIPLE_CHOICES, HttpResponseStatus.MULTIPLE_CHOICES);
        map.put(RestStatus.MOVED_PERMANENTLY, HttpResponseStatus.MOVED_PERMANENTLY);
        map.put(RestStatus.FOUND, HttpResponseStatus.FOUND);
        map.put(RestStatus.SEE_OTHER, HttpResponseStatus.SEE_OTHER);
        map.put(RestStatus.NOT_MODIFIED, HttpResponseStatus.NOT_MODIFIED);
        map.put(RestStatus.USE_PROXY, HttpResponseStatus.USE_PROXY);
        map.put(RestStatus.TEMPORARY_REDIRECT, HttpResponseStatus.TEMPORARY_REDIRECT);
        map.put(RestStatus.BAD_REQUEST, HttpResponseStatus.BAD_REQUEST);
        map.put(RestStatus.UNAUTHORIZED, HttpResponseStatus.UNAUTHORIZED);
        map.put(RestStatus.PAYMENT_REQUIRED, HttpResponseStatus.PAYMENT_REQUIRED);
        map.put(RestStatus.FORBIDDEN, HttpResponseStatus.FORBIDDEN);
        map.put(RestStatus.NOT_FOUND, HttpResponseStatus.NOT_FOUND);
        map.put(RestStatus.METHOD_NOT_ALLOWED, HttpResponseStatus.METHOD_NOT_ALLOWED);
        map.put(RestStatus.NOT_ACCEPTABLE, HttpResponseStatus.NOT_ACCEPTABLE);
        map.put(RestStatus.PROXY_AUTHENTICATION, HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED);
        map.put(RestStatus.REQUEST_TIMEOUT, HttpResponseStatus.REQUEST_TIMEOUT);
        map.put(RestStatus.CONFLICT, HttpResponseStatus.CONFLICT);
        map.put(RestStatus.GONE, HttpResponseStatus.GONE);
        map.put(RestStatus.LENGTH_REQUIRED, HttpResponseStatus.LENGTH_REQUIRED);
        map.put(RestStatus.PRECONDITION_FAILED, HttpResponseStatus.PRECONDITION_FAILED);
        map.put(RestStatus.REQUEST_ENTITY_TOO_LARGE, HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
        map.put(RestStatus.REQUEST_URI_TOO_LONG, HttpResponseStatus.REQUEST_URI_TOO_LONG);
        map.put(RestStatus.UNSUPPORTED_MEDIA_TYPE, HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE);
        map.put(RestStatus.REQUESTED_RANGE_NOT_SATISFIED, HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE);
        map.put(RestStatus.EXPECTATION_FAILED, HttpResponseStatus.EXPECTATION_FAILED);
        map.put(RestStatus.UNPROCESSABLE_ENTITY, HttpResponseStatus.BAD_REQUEST);
        map.put(RestStatus.LOCKED, HttpResponseStatus.BAD_REQUEST);
        map.put(RestStatus.FAILED_DEPENDENCY, HttpResponseStatus.BAD_REQUEST);
        map.put(RestStatus.TOO_MANY_REQUESTS, TOO_MANY_REQUESTS);
        map.put(RestStatus.INTERNAL_SERVER_ERROR, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        map.put(RestStatus.NOT_IMPLEMENTED, HttpResponseStatus.NOT_IMPLEMENTED);
        map.put(RestStatus.BAD_GATEWAY, HttpResponseStatus.BAD_GATEWAY);
        map.put(RestStatus.SERVICE_UNAVAILABLE, HttpResponseStatus.SERVICE_UNAVAILABLE);
        map.put(RestStatus.GATEWAY_TIMEOUT, HttpResponseStatus.GATEWAY_TIMEOUT);
        map.put(RestStatus.HTTP_VERSION_NOT_SUPPORTED, HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED);
        MAP = Collections.unmodifiableMap(map);
    }
}

