/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.ObjectHashSet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.MultiPhraseQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.StringHelper;
import org.elasticsearch.common.lucene.search.Queries;

public class MultiPhrasePrefixQuery
extends Query {
    private String field;
    private ArrayList<Term[]> termArrays = new ArrayList();
    private ArrayList<Integer> positions = new ArrayList();
    private int maxExpansions = Integer.MAX_VALUE;
    private int slop = 0;

    public void setSlop(int s) {
        this.slop = s;
    }

    public void setMaxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
    }

    public int getSlop() {
        return this.slop;
    }

    public void add(Term term) {
        this.add(new Term[]{term});
    }

    public void add(Term[] terms) {
        int position = 0;
        if (this.positions.size() > 0) {
            position = this.positions.get(this.positions.size() - 1) + 1;
        }
        this.add(terms, position);
    }

    public void add(Term[] terms, int position) {
        if (this.termArrays.size() == 0) {
            this.field = terms[0].field();
        }
        for (int i = 0; i < terms.length; ++i) {
            if (terms[i].field() == this.field) continue;
            throw new IllegalArgumentException("All phrase terms must be in the same field (" + this.field + "): " + terms[i]);
        }
        this.termArrays.add(terms);
        this.positions.add(position);
    }

    public Term[][] getTerms() {
        Term[][] terms = new Term[this.termArrays.size()][];
        for (int i = 0; i < this.termArrays.size(); ++i) {
            terms[i] = new Term[this.termArrays.get(i).length];
            for (int j = 0; j < this.termArrays.get(i).length; ++j) {
                terms[i][j] = this.termArrays.get(i)[j];
            }
        }
        return terms;
    }

    public int[] getPositions() {
        int[] result = new int[this.positions.size()];
        for (int i = 0; i < this.positions.size(); ++i) {
            result[i] = this.positions.get(i);
        }
        return result;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = super.rewrite(reader);
        if (rewritten != this) {
            return rewritten;
        }
        if (this.termArrays.isEmpty()) {
            return new MatchNoDocsQuery();
        }
        MultiPhraseQuery.Builder query = new MultiPhraseQuery.Builder();
        query.setSlop(this.slop);
        int sizeMinus1 = this.termArrays.size() - 1;
        for (int i = 0; i < sizeMinus1; ++i) {
            query.add(this.termArrays.get(i), this.positions.get(i));
        }
        Term[] suffixTerms = this.termArrays.get(sizeMinus1);
        int position = this.positions.get(sizeMinus1);
        ObjectHashSet<Term> terms = new ObjectHashSet<Term>();
        for (Term term : suffixTerms) {
            this.getPrefixTerms(terms, term, reader);
            if (terms.size() > this.maxExpansions) break;
        }
        if (terms.isEmpty()) {
            return new BooleanQuery.Builder().add(query.build(), BooleanClause.Occur.MUST).add(Queries.newMatchNoDocsQuery("No terms supplied for " + MultiPhrasePrefixQuery.class.getName()), BooleanClause.Occur.MUST).build();
        }
        query.add((Term[])terms.toArray(Term.class), position);
        return query.build();
    }

    private void getPrefixTerms(ObjectHashSet<Term> terms, Term prefix, IndexReader reader) throws IOException {
        List<LeafReaderContext> leaves = reader.leaves();
        for (LeafReaderContext leaf : leaves) {
            TermsEnum termsEnum;
            TermsEnum.SeekStatus seekStatus;
            Terms _terms = leaf.reader().terms(this.field);
            if (_terms == null || TermsEnum.SeekStatus.END == (seekStatus = (termsEnum = _terms.iterator()).seekCeil(prefix.bytes()))) continue;
            BytesRef term = termsEnum.term();
            while (term != null && StringHelper.startsWith(term, prefix.bytes())) {
                terms.add(new Term(this.field, BytesRef.deepCopyOf(term)));
                if (terms.size() >= this.maxExpansions) {
                    return;
                }
                term = termsEnum.next();
            }
        }
    }

    @Override
    public final String toString(String f) {
        StringBuilder buffer = new StringBuilder();
        if (this.field == null || !this.field.equals(f)) {
            buffer.append(this.field);
            buffer.append(":");
        }
        buffer.append("\"");
        Iterator<Term[]> i = this.termArrays.iterator();
        while (i.hasNext()) {
            Term[] terms = i.next();
            if (terms.length > 1) {
                buffer.append("(");
                for (int j = 0; j < terms.length; ++j) {
                    buffer.append(terms[j].text());
                    if (j >= terms.length - 1) continue;
                    if (i.hasNext()) {
                        buffer.append(" ");
                        continue;
                    }
                    buffer.append("* ");
                }
                if (i.hasNext()) {
                    buffer.append(") ");
                    continue;
                }
                buffer.append("*)");
                continue;
            }
            buffer.append(terms[0].text());
            if (i.hasNext()) {
                buffer.append(" ");
                continue;
            }
            buffer.append("*");
        }
        buffer.append("\"");
        if (this.slop != 0) {
            buffer.append("~");
            buffer.append(this.slop);
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!this.sameClassAs(o)) {
            return false;
        }
        MultiPhrasePrefixQuery other = (MultiPhrasePrefixQuery)o;
        return this.slop == other.slop && this.termArraysEquals(this.termArrays, other.termArrays) && this.positions.equals(other.positions);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.slop ^ this.termArraysHashCode() ^ this.positions.hashCode();
    }

    private int termArraysHashCode() {
        int hashCode = 1;
        for (Object[] objectArray : this.termArrays) {
            hashCode = 31 * hashCode + (objectArray == null ? 0 : Arrays.hashCode(objectArray));
        }
        return hashCode;
    }

    private boolean termArraysEquals(List<Term[]> termArrays1, List<Term[]> termArrays2) {
        if (termArrays1.size() != termArrays2.size()) {
            return false;
        }
        ListIterator<Term[]> iterator1 = termArrays1.listIterator();
        ListIterator<Term[]> iterator2 = termArrays2.listIterator();
        while (iterator1.hasNext()) {
            Object[] termArray1 = iterator1.next();
            Object[] termArray2 = iterator2.next();
            if (termArray1 != null ? Arrays.equals(termArray1, termArray2) : termArray2 == null) continue;
            return false;
        }
        return true;
    }

    public String getField() {
        return this.field;
    }
}

