/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.snapshots.Snapshot;

public class RestoreInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final String TYPE = "restore";
    private final List<Entry> entries;

    public RestoreInProgress(List<Entry> entries) {
        this.entries = entries;
    }

    public RestoreInProgress(Entry ... entries) {
        this.entries = Arrays.asList(entries);
    }

    public List<Entry> entries() {
        return this.entries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreInProgress that = (RestoreInProgress)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return RestoreInProgress.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    public RestoreInProgress(StreamInput in) throws IOException {
        Entry[] entries = new Entry[in.readVInt()];
        for (int i = 0; i < entries.length; ++i) {
            Snapshot snapshot = new Snapshot(in);
            State state = State.fromValue(in.readByte());
            int indices = in.readVInt();
            ArrayList<String> indexBuilder = new ArrayList<String>();
            for (int j = 0; j < indices; ++j) {
                indexBuilder.add(in.readString());
            }
            ImmutableOpenMap.Builder<ShardId, ShardRestoreStatus> builder = ImmutableOpenMap.builder();
            int shards = in.readVInt();
            for (int j = 0; j < shards; ++j) {
                ShardId shardId = ShardId.readShardId(in);
                ShardRestoreStatus shardState = ShardRestoreStatus.readShardRestoreStatus(in);
                builder.put(shardId, shardState);
            }
            entries[i] = new Entry(snapshot, state, Collections.unmodifiableList(indexBuilder), builder.build());
        }
        this.entries = Arrays.asList(entries);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.entries.size());
        for (Entry entry : this.entries) {
            entry.snapshot().writeTo(out);
            out.writeByte(entry.state().value());
            out.writeVInt(entry.indices().size());
            for (String string : entry.indices()) {
                out.writeString(string);
            }
            out.writeVInt(entry.shards().size());
            for (ObjectObjectCursor objectObjectCursor : entry.shards()) {
                ((ShardId)objectObjectCursor.key).writeTo(out);
                ((ShardRestoreStatus)objectObjectCursor.value).writeTo(out);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("snapshots");
        for (Entry entry : this.entries) {
            this.toXContent(entry, builder, params);
        }
        builder.endArray();
        return builder;
    }

    public void toXContent(Entry entry, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("snapshot", entry.snapshot().getSnapshotId().getName());
        builder.field("repository", entry.snapshot().getRepository());
        builder.field("state", (Object)entry.state());
        builder.startArray("indices");
        for (String index : entry.indices()) {
            builder.value(index);
        }
        builder.endArray();
        builder.startArray("shards");
        for (ObjectObjectCursor shardEntry : entry.shards) {
            ShardId shardId = (ShardId)shardEntry.key;
            ShardRestoreStatus status = (ShardRestoreStatus)shardEntry.value;
            builder.startObject();
            builder.field("index", shardId.getIndex());
            builder.field("shard", shardId.getId());
            builder.field("state", (Object)status.state());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
    }

    public static enum State {
        INIT(0),
        STARTED(1),
        SUCCESS(2),
        FAILURE(3);

        private byte value;

        private State(byte value) {
            this.value = value;
        }

        public byte value() {
            return this.value;
        }

        public boolean completed() {
            return this == SUCCESS || this == FAILURE;
        }

        public static State fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 1: {
                    return STARTED;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILURE;
                }
            }
            throw new IllegalArgumentException("No snapshot state for value [" + value + "]");
        }
    }

    public static class ShardRestoreStatus {
        private State state;
        private String nodeId;
        private String reason;

        private ShardRestoreStatus() {
        }

        public ShardRestoreStatus(String nodeId) {
            this(nodeId, State.INIT);
        }

        public ShardRestoreStatus(String nodeId, State state) {
            this(nodeId, state, null);
        }

        public ShardRestoreStatus(String nodeId, State state, String reason) {
            this.nodeId = nodeId;
            this.state = state;
            this.reason = reason;
        }

        public State state() {
            return this.state;
        }

        public String nodeId() {
            return this.nodeId;
        }

        public String reason() {
            return this.reason;
        }

        public static ShardRestoreStatus readShardRestoreStatus(StreamInput in) throws IOException {
            ShardRestoreStatus shardSnapshotStatus = new ShardRestoreStatus();
            shardSnapshotStatus.readFrom(in);
            return shardSnapshotStatus;
        }

        public void readFrom(StreamInput in) throws IOException {
            this.nodeId = in.readOptionalString();
            this.state = State.fromValue(in.readByte());
            this.reason = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.nodeId);
            out.writeByte(this.state.value);
            out.writeOptionalString(this.reason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardRestoreStatus status = (ShardRestoreStatus)o;
            return this.state == status.state && Objects.equals(this.nodeId, status.nodeId) && Objects.equals(this.reason, status.reason);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state, this.nodeId, this.reason});
        }
    }

    public static class Entry {
        private final State state;
        private final Snapshot snapshot;
        private final ImmutableOpenMap<ShardId, ShardRestoreStatus> shards;
        private final List<String> indices;

        public Entry(Snapshot snapshot, State state, List<String> indices, ImmutableOpenMap<ShardId, ShardRestoreStatus> shards) {
            this.snapshot = Objects.requireNonNull(snapshot);
            this.state = Objects.requireNonNull(state);
            this.indices = Objects.requireNonNull(indices);
            this.shards = shards == null ? ImmutableOpenMap.of() : shards;
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public ImmutableOpenMap<ShardId, ShardRestoreStatus> shards() {
            return this.shards;
        }

        public State state() {
            return this.state;
        }

        public List<String> indices() {
            return this.indices;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.snapshot.equals(entry.snapshot) && this.state == entry.state && this.indices.equals(entry.indices) && this.shards.equals(entry.shards);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.snapshot, this.state, this.indices, this.shards});
        }
    }
}

