/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldstats;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.action.support.broadcast.BroadcastShardResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class FieldStatsShardResponse
extends BroadcastShardResponse {
    private Map<String, FieldStats<?>> fieldStats;

    public FieldStatsShardResponse() {
    }

    public FieldStatsShardResponse(ShardId shardId, Map<String, FieldStats<?>> fieldStats) {
        super(shardId);
        this.fieldStats = fieldStats;
    }

    public Map<String, FieldStats<?>> getFieldStats() {
        return this.fieldStats;
    }

    Map<String, FieldStats<?>> filterNullMinMax() {
        return this.fieldStats.entrySet().stream().filter(e -> ((FieldStats)e.getValue()).hasMinMax()).collect(Collectors.toMap(p -> (String)p.getKey(), p -> (FieldStats)p.getValue()));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.fieldStats = new HashMap(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            FieldStats value = FieldStats.readFrom(in);
            this.fieldStats.put(key, value);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        Map<String, FieldStats<?>> stats = out.getVersion().before(Version.V_5_2_0_UNRELEASED) ? this.filterNullMinMax() : this.getFieldStats();
        out.writeVInt(stats.size());
        for (Map.Entry<String, FieldStats<?>> entry : stats.entrySet()) {
            out.writeString(entry.getKey());
            entry.getValue().writeTo(out);
        }
    }
}

